/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.distfork;

import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.plugins.distfork.DistForkTask;
import hudson.plugins.distfork.PortForwardingArgumentHandler;
import hudson.plugins.distfork.PortSpec;
import hudson.plugins.distfork.RestOfArgumentsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Extension
public class DistForkCommand
extends CLICommand {
    @Option(name="-l", usage="Label for controlling where to execute this command")
    public String label;
    @Option(name="-n", usage="Human readable name that describe this command. Used in Hudson's UI.")
    public String name;
    @Option(name="-d", usage="Estimated duration of this task in milliseconds, or -1 if unknown")
    public long duration = -1L;
    @Argument(handler=RestOfArgumentsHandler.class)
    public List<String> commands = new ArrayList();
    @Option(name="-z", metaVar="FILE", usage="Zip/tgz file to be extracted into the target remote machine before execution of the command")
    public String zip;
    @Option(name="-Z", metaVar="FILE", usage="Bring back the newly added/updated files in the target remote machine after the end of the command by creating a zip/tgz bundle and place this in the local file system by this name.")
    public String returnZip;
    @Option(name="-e", usage="Environment variables to set to the launched process", metaVar="NAME=VAL")
    public Map<String, String> envs = new HashMap();
    @Option(name="-f", usage="Local files to be copied to remote locations before the execution of a task", metaVar="REMOTE=LOCAL")
    public Map<String, String> files = new HashMap();
    @Option(name="-F", usage="Remote files to be copied back to local locations after the execution of a task", metaVar="LOCAL=REMOTE")
    public Map<String, String> returnFiles = new HashMap();
    @Option(name="-L", usage="Local to remote port forwarding", handler=PortForwardingArgumentHandler.class)
    public List<PortSpec> l2rFowrarding = new ArrayList();
    @Option(name="-R", usage="Remote to local port forwarding", handler=PortForwardingArgumentHandler.class)
    public List<PortSpec> r2lFowrarding = new ArrayList();

    public String getShortDescription() {
        return "forks a process on a remote machine and connects to its stdin/stdout";
    }

    protected int run() throws Exception {
        if (this.commands.isEmpty()) {
            throw new CmdLineException(null, "No commands are specified");
        }
        Hudson h = Hudson.getInstance();
        Label l = null;
        if (this.label != null && (l = h.getLabel(this.label)).isEmpty()) {
            this.stderr.println("No such label: " + this.label);
            return -1;
        }
        if (this.name == null) {
            boolean dots = false;
            if (this.commands.size() > 3) {
                this.name = Util.join(this.commands.subList(0, 3), (String)" ");
                dots = true;
            }
            this.name = Util.join((Collection)this.commands, (String)" ");
            if (this.name.length() > 80) {
                this.name = this.name.substring(0, 80);
                dots = true;
            }
            if (dots) {
                this.name = this.name + " ...";
            }
        }
        int[] exitCode = new int[]{-1};
        DistForkTask t = new DistForkTask(l, this.name, this.duration, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        Queue q = h.getQueue();
        Future f = q.schedule((Queue.Task)t, 0).getFuture();
        try {
            f.get();
        }
        catch (CancellationException e) {
            this.stderr.println("Task cancelled");
            return -1;
        }
        catch (InterruptedException e) {
            f.cancel(true);
            throw e;
        }
        return exitCode[0];
    }
}

