/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.DocLinksAction;
import hudson.plugins.doclinks.DocLinksPublisher;
import hudson.plugins.doclinks.DocLinksUtil;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.Messages;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DocLinksPublisher
extends Publisher {
    public static final Descriptor<Publisher> DESCRIPTOR = new DocLinksDescriptor();
    private final List<Document> documents;

    public static File getDocLinksDir(AbstractItem project) {
        return new File(project.getRootDir(), "doclinks");
    }

    public DocLinksPublisher(List<Document> docs) {
        this.documents = docs;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksAction(project, map);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath docLinksDir = new FilePath(DocLinksPublisher.getDocLinksDir((AbstractItem)build.getProject()));
        try {
            docLinksDir.deleteRecursive();
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        for (Document doc : this.documents) {
            FilePath docDir;
            String directory = doc.getDirectory();
            if (!DocLinksUtil.isValidDirectory((String)directory)) {
                String cause = Messages.DocLinksPublisher_DirectoryInvalid();
                DocLinksUtil.log((PrintStream)logger, (String)Messages.DocLinksPublisher_SkipDocument((Object)doc.getTitle(), (Object)cause));
                continue;
            }
            FilePath ws = ((AbstractProject)build.getParent()).getWorkspace();
            FilePath filePath = docDir = directory != null ? ws.child(directory) : ws;
            if (!docDir.exists()) {
                String cause = Messages.DocLinksPublisher_DirectoryNotExist((Object)docDir.getName());
                DocLinksUtil.log((PrintStream)logger, (String)Messages.DocLinksPublisher_SkipDocument((Object)doc.getTitle(), (Object)cause));
                continue;
            }
            FilePath target = new FilePath(docLinksDir, String.valueOf(doc.getId()));
            try {
                DocLinksUtil.log((PrintStream)logger, (String)Messages.DocLinksPublisher_CopyDocument((Object)doc.getTitle(), (Object)target.getName()));
                docDir.copyRecursiveTo("**/*", target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }
}

