/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.plugins.doclinks.Document;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLinksUtil {
    private DocLinksUtil() {
    }

    public static void log(PrintStream logger, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append("DocLinks").append("] ").append(message);
        logger.println(builder.toString());
    }

    public static String getNextId(List<Document> documents) {
        int max = 0;
        for (Document doc : documents) {
            if (doc.getId() == null) continue;
            int id = Integer.parseInt(doc.getId());
            max = Math.max(max, id);
        }
        return String.valueOf(max + 1);
    }

    public static boolean isValidDirectory(String dir) {
        if (dir == null) {
            return true;
        }
        String d = dir.replace("\\", "/");
        if (!d.endsWith("/")) {
            d = d + "/";
        }
        return d.indexOf("../") == -1;
    }
}

