/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.Util;
import hudson.model.AbstractItem;
import hudson.plugins.doclinks.DocLinksPublisher;
import java.io.File;
import org.kohsuke.stapler.DataBoundConstructor;

public class Document {
    private final String title;
    private final String description;
    private final String directory;
    private final String file;
    private String id;

    @DataBoundConstructor
    public Document(String title, String description, String directory, String file, String id) {
        this.title = Util.fixEmptyAndTrim((String)title);
        this.description = Util.fixEmptyAndTrim((String)description);
        this.directory = Util.fixEmptyAndTrim((String)directory);
        this.file = Util.fixEmptyAndTrim((String)file);
        this.id = Util.fixEmptyAndTrim((String)id);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFile() {
        return this.file;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasResources(AbstractItem project) {
        File docLinksDir = DocLinksPublisher.getDocLinksDir((AbstractItem)project);
        File docDir = new File(docLinksDir, String.valueOf(this.getId()));
        if (this.file == null) {
            return docDir.exists();
        }
        File indexFile = new File(docDir, this.file);
        return indexFile.exists();
    }
}

