/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.plugins.doclinks.DocLinksPublisher;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.Messages;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLinksAction
implements Action {
    private final AbstractItem project;
    private final Map<String, Document> documents;
    private static final Logger LOGGER = Logger.getLogger(DocLinksAction.class.getName());

    public DocLinksAction(AbstractItem project, Map<String, Document> document) {
        this.project = project;
        this.documents = document;
    }

    public Map<String, Document> getDocumentsMap() {
        return Collections.unmodifiableMap(this.documents);
    }

    public String getDisplayName() {
        return "";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "doclinks";
    }

    public boolean hasDocument(Document doc) {
        return doc.hasResources(this.project);
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String id = this.getDocumentId(req.getRestOfPath());
        if (id == null) {
            LOGGER.warning(Messages.DocLinksAction_IllegalURI(req.getRestOfPath()));
            rsp.sendError(404);
            return null;
        }
        Document doc = this.documents.get(id);
        if (doc == null) {
            LOGGER.warning(Messages.DocLinksAction_DocumentNotFound());
            rsp.sendError(404);
            return null;
        }
        FilePath basePath = new FilePath(DocLinksPublisher.getDocLinksDir(this.project));
        DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, basePath, "DocLinks", null, false);
        if (doc.getFile() != null) {
            dbs.setIndexFileName(doc.getFile());
        }
        return dbs;
    }

    private String getDocumentId(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        if (tokenizer.hasMoreElements()) {
            return tokenizer.nextToken();
        }
        return null;
    }
}

