/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.DocLinksAction;
import hudson.plugins.doclinks.DocLinksUtil;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLinksPublisher
extends Publisher {
    public static final Descriptor<Publisher> DESCRIPTOR = new DocLinksDescriptor();
    private final List<Document> documents;

    public static File getDocLinksDir(AbstractItem project) {
        return new File(project.getRootDir(), "doclinks");
    }

    public DocLinksPublisher(List<Document> docs) {
        this.documents = docs;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksAction((AbstractItem)project, (Map<String, Document>)map);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath docLinksDir = new FilePath(DocLinksPublisher.getDocLinksDir((AbstractItem)build.getProject()));
        try {
            docLinksDir.deleteRecursive();
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        for (Document doc : this.documents) {
            FilePath docDir;
            String directory = doc.getDirectory();
            if (!DocLinksUtil.isValidDirectory(directory)) {
                String cause = Messages.DocLinksPublisher_DirectoryInvalid();
                DocLinksUtil.log(logger, Messages.DocLinksPublisher_SkipDocument(doc.getTitle(), cause));
                continue;
            }
            FilePath ws = ((AbstractProject)build.getParent()).getWorkspace();
            FilePath filePath = docDir = directory != null ? ws.child(directory) : ws;
            if (!docDir.exists()) {
                String cause = Messages.DocLinksPublisher_DirectoryNotExist(docDir.getName());
                DocLinksUtil.log(logger, Messages.DocLinksPublisher_SkipDocument(doc.getTitle(), cause));
                continue;
            }
            FilePath target = new FilePath(docLinksDir, String.valueOf(doc.getId()));
            try {
                DocLinksUtil.log(logger, Messages.DocLinksPublisher_CopyDocument(doc.getTitle(), target.getName()));
                docDir.copyRecursiveTo("**/*", target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocLinksDescriptor
    extends BuildStepDescriptor<Publisher> {
        public DocLinksDescriptor() {
            super(DocLinksPublisher.class);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List docs = req.bindParametersToList(Document.class, "doc.");
            for (Document doc : docs) {
                if (doc.getId() != null) continue;
                doc.setId(DocLinksUtil.getNextId(docs));
            }
            return new DocLinksPublisher(docs);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckTitle(@QueryParameter String title) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            title = Util.fixEmptyAndTrim((String)title);
            if (title == null) {
                return FormValidation.error((String)Messages.DocLinksPublisher_Required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDirectory(@AncestorInPath AbstractProject project, @QueryParameter String dir) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            dir = Util.fixEmptyAndTrim((String)dir);
            if (!DocLinksUtil.isValidDirectory(dir)) {
                return FormValidation.error((String)Messages.DocLinksPublisher_DirectoryInvalid());
            }
            FilePath ws = project.getWorkspace();
            return ws != null ? ws.validateRelativeDirectory(dir) : FormValidation.ok();
        }

        public FormValidation doCheckFile(@AncestorInPath AbstractProject project, @QueryParameter String dir, @QueryParameter String file) throws IOException, ServletException {
            FilePath ws;
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            file = Util.fixEmptyAndTrim((String)file);
            if (file == null) {
                FormValidation.ok();
            }
            if ((ws = project.getWorkspace()) == null) {
                return FormValidation.ok();
            }
            FilePath targetDir = (dir = Util.fixEmptyAndTrim((String)dir)) != null ? new FilePath(ws, dir) : ws;
            return targetDir.validateRelativePath(file, true, true);
        }

        public String getDisplayName() {
            return Messages.DocLinksPublisher_DisplayName();
        }
    }
}

