// CHECKSTYLE:OFF

package hudson.plugins.doclinks.m2;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Required.
     * 
     */
    public static String DocLinksMavenReporter_Required() {
        return holder.format("DocLinksMavenReporter.Required");
    }

    /**
     * Required.
     * 
     */
    public static Localizable _DocLinksMavenReporter_Required() {
        return new Localizable(holder, "DocLinksMavenReporter.Required");
    }

    /**
     * {0} is illegal URI.
     * 
     */
    public static String DocLinksMavenAction_IllegalURI(Object arg1) {
        return holder.format("DocLinksMavenAction.IllegalURI", arg1);
    }

    /**
     * {0} is illegal URI.
     * 
     */
    public static Localizable _DocLinksMavenAction_IllegalURI(Object arg1) {
        return new Localizable(holder, "DocLinksMavenAction.IllegalURI", arg1);
    }

    /**
     * Skip document {0} ... ({1})
     * 
     */
    public static String DocLinksMavenReporter_SkipDocument(Object arg1, Object arg2) {
        return holder.format("DocLinksMavenReporter.SkipDocument", arg1, arg2);
    }

    /**
     * Skip document {0} ... ({1})
     * 
     */
    public static Localizable _DocLinksMavenReporter_SkipDocument(Object arg1, Object arg2) {
        return new Localizable(holder, "DocLinksMavenReporter.SkipDocument", arg1, arg2);
    }

    /**
     * Copying {0} to {1} ...
     * 
     */
    public static String DocLinksMavenReporter_CopyDocument(Object arg1, Object arg2) {
        return holder.format("DocLinksMavenReporter.CopyDocument", arg1, arg2);
    }

    /**
     * Copying {0} to {1} ...
     * 
     */
    public static Localizable _DocLinksMavenReporter_CopyDocument(Object arg1, Object arg2) {
        return new Localizable(holder, "DocLinksMavenReporter.CopyDocument", arg1, arg2);
    }

    /**
     * Directory seems to be invalid.
     * 
     */
    public static String DocLinksMavenReporter_DirectoryInvalid() {
        return holder.format("DocLinksMavenReporter.DirectoryInvalid");
    }

    /**
     * Directory seems to be invalid.
     * 
     */
    public static Localizable _DocLinksMavenReporter_DirectoryInvalid() {
        return new Localizable(holder, "DocLinksMavenReporter.DirectoryInvalid");
    }

    /**
     * No such document.
     * 
     */
    public static String DocLinksMavenAction_DocumentNotFound() {
        return holder.format("DocLinksMavenAction.DocumentNotFound");
    }

    /**
     * No such document.
     * 
     */
    public static Localizable _DocLinksMavenAction_DocumentNotFound() {
        return new Localizable(holder, "DocLinksMavenAction.DocumentNotFound");
    }

    /**
     * Publish documents
     * 
     */
    public static String DocLinksMavenReporter_DisplayName() {
        return holder.format("DocLinksMavenReporter.DisplayName");
    }

    /**
     * Publish documents
     * 
     */
    public static Localizable _DocLinksMavenReporter_DisplayName() {
        return new Localizable(holder, "DocLinksMavenReporter.DisplayName");
    }

    /**
     * No such directory: {0}
     * 
     */
    public static String DocLinksMavenReporter_DirectoryNotExist(Object arg1) {
        return holder.format("DocLinksMavenReporter.DirectoryNotExist", arg1);
    }

    /**
     * No such directory: {0}
     * 
     */
    public static Localizable _DocLinksMavenReporter_DirectoryNotExist(Object arg1) {
        return new Localizable(holder, "DocLinksMavenReporter.DirectoryNotExist", arg1);
    }

}
