/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.DocLinksAction;
import hudson.plugins.doclinks.DocLinksUtils;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLinksPublisher
extends Recorder {
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DocLinksDescriptor();
    private final List<Document> documents;

    public static File getDocLinksDir(AbstractItem project) {
        return new File(project.getRootDir(), "doclinks");
    }

    public DocLinksPublisher(List<Document> docs) {
        this.documents = docs;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksAction((AbstractItem)project, (Map<String, Document>)map);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath ws = ((AbstractProject)build.getParent()).getWorkspace();
        FilePath docLinksDir = new FilePath(DocLinksPublisher.getDocLinksDir((AbstractItem)build.getProject()));
        try {
            docLinksDir.deleteRecursive();
            for (Document doc : this.documents) {
                DocLinksUtils.publishDocument(doc, ws, docLinksDir, logger);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocLinksDescriptor
    extends BuildStepDescriptor<Publisher> {
        public DocLinksDescriptor() {
            super(DocLinksPublisher.class);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List docs = req.bindParametersToList(Document.class, "doc.");
            for (Document doc : docs) {
                if (doc.getId() != null) continue;
                doc.setId(DocLinksUtils.getNextId(docs));
            }
            return new DocLinksPublisher(docs);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return !AbstractMavenProject.class.isAssignableFrom(jobType);
        }

        public FormValidation doCheckTitle(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String title) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return DocLinksUtils.validateTitle(title);
        }

        public FormValidation doCheckDirectory(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String dir) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return DocLinksUtils.validateDirectory(project, dir);
        }

        public FormValidation doCheckFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String dir, @QueryParameter String file) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return DocLinksUtils.validateFile(project, dir, file);
        }

        public String getDisplayName() {
            return Messages.DocLinksPublisher_DisplayName();
        }
    }
}

