/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class DocLinksUtils {
    private DocLinksUtils() {
    }

    public static void log(PrintStream logger, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append("DocLinks").append("] ").append(message);
        logger.println(builder.toString());
    }

    public static synchronized String getNextId(List<Document> documents) {
        int max = 0;
        for (Document doc : documents) {
            if (doc.getId() == null) continue;
            int id = Integer.parseInt(doc.getId());
            max = Math.max(max, id);
        }
        return String.valueOf(max + 1);
    }

    public static boolean isValidDirectory(String dir) {
        if (dir == null) {
            return true;
        }
        String d = dir.replace("\\", "/");
        if (!d.endsWith("/")) {
            d = d + "/";
        }
        return d.indexOf("../") == -1;
    }

    public static String getDocumentId(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        if (tokenizer.hasMoreElements()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    public static FormValidation validateTitle(String title) {
        String t = Util.fixEmptyAndTrim((String)title);
        if (t == null) {
            return FormValidation.error((String)Messages.DocLinksUtils_Required());
        }
        return FormValidation.ok();
    }

    public static FormValidation validateDirectory(AbstractProject project, String directory) throws IOException {
        String dir = Util.fixEmptyAndTrim((String)directory);
        if (!DocLinksUtils.isValidDirectory((String)dir)) {
            return FormValidation.error((String)Messages.DocLinksUtils_DirectoryInvalid());
        }
        FilePath ws = project.getWorkspace();
        return ws != null ? ws.validateRelativeDirectory(dir) : FormValidation.ok();
    }

    public static FormValidation validateFile(AbstractProject project, String directory, String file) throws IOException {
        FilePath ws;
        String f = Util.fixEmptyAndTrim((String)file);
        if (f == null) {
            FormValidation.ok();
        }
        if ((ws = project.getWorkspace()) == null) {
            return FormValidation.ok();
        }
        String dir = Util.fixEmptyAndTrim((String)directory);
        FilePath targetDir = dir != null ? new FilePath(ws, dir) : ws;
        return targetDir.validateRelativePath(file, true, true);
    }

    public static void publishDocument(Document doc, FilePath ws, FilePath docLinksDir, PrintStream logger) throws IOException, InterruptedException {
        FilePath docDir;
        String directory = doc.getDirectory();
        if (!DocLinksUtils.isValidDirectory((String)directory)) {
            String cause = Messages.DocLinksUtils_DirectoryInvalid();
            DocLinksUtils.log((PrintStream)logger, (String)Messages.DocLinksUtils_SkipDocument((Object)doc.getTitle(), (Object)cause));
            throw new IOException();
        }
        FilePath filePath = docDir = directory != null ? ws.child(directory) : ws;
        if (!docDir.exists()) {
            String cause = Messages.DocLinksUtils_DirectoryNotExist((Object)docDir.getName());
            DocLinksUtils.log((PrintStream)logger, (String)Messages.DocLinksUtils_SkipDocument((Object)doc.getTitle(), (Object)cause));
        }
        FilePath target = new FilePath(docLinksDir, String.valueOf(doc.getId()));
        DocLinksUtils.log((PrintStream)logger, (String)Messages.DocLinksUtils_CopyDocument((Object)doc.getTitle(), (Object)target.getName()));
        docDir.copyRecursiveTo("**/*", target);
    }
}

