/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks.m2;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.DocLinksUtils;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.m2.DocLinksMavenAction;
import hudson.plugins.doclinks.m2.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLinksMavenReporter
extends MavenReporter {
    private static final long serialVersionUID = 1L;
    public static final MavenReporterDescriptor DESCRIPTOR = new DocLinksMavenReporterDescriptor();
    private final List<Document> documents;
    private static final Logger LOGGER = Logger.getLogger(DocLinksMavenReporter.class.getName());

    public DocLinksMavenReporter(List<Document> docs) {
        this.documents = docs;
    }

    public static File getDocLinksDir(MavenModule module) {
        return new File(module.getRootDir(), "doclinks");
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public Action getProjectAction(MavenModule module) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksMavenAction(module, map);
    }

    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath ws = build.getParent().getWorkspace();
        FilePath docLinksDir = new FilePath(DocLinksMavenReporter.getDocLinksDir(build.getParent()));
        try {
            docLinksDir.deleteRecursive();
            for (Document doc : this.documents) {
                DocLinksUtils.publishDocument(doc, ws, docLinksDir, logger);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        build.registerAsProjectAction((MavenReporter)this);
        return true;
    }

    public static class DocLinksMavenReporterDescriptor
    extends MavenReporterDescriptor {
        public DocLinksMavenReporterDescriptor() {
            super(DocLinksMavenReporter.class);
        }

        public DocLinksMavenReporter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List docs = req.bindParametersToList(Document.class, "doc.");
            for (Document doc : docs) {
                if (doc.getId() != null) continue;
                doc.setId(DocLinksUtils.getNextId(docs));
            }
            return new DocLinksMavenReporter(docs);
        }

        public FormValidation doCheckTitle(@QueryParameter String title) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return DocLinksUtils.validateTitle(title);
        }

        public FormValidation doCheckDirectory(@AncestorInPath AbstractProject project, @QueryParameter String dir) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return DocLinksUtils.validateDirectory(project, dir);
        }

        public FormValidation doCheckFile(@AncestorInPath AbstractProject project, @QueryParameter String dir, @QueryParameter String file) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return DocLinksUtils.validateFile(project, dir, file);
        }

        public String getDisplayName() {
            return Messages.DocLinksMavenReporter_DisplayName();
        }
    }
}

