/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.DocLinksAction;
import hudson.plugins.doclinks.DocLinksPublisher;
import hudson.plugins.doclinks.DocLinksUtils;
import hudson.plugins.doclinks.Document;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DocLinksPublisher
extends Recorder {
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DocLinksDescriptor();
    private final List<Document> documents;

    public static File getDocLinksDir(AbstractItem project) {
        return new File(project.getRootDir(), "doclinks");
    }

    public DocLinksPublisher(List<Document> docs) {
        this.documents = docs;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksAction(project, map);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath ws = build.getWorkspace();
        FilePath docLinksDir = new FilePath(DocLinksPublisher.getDocLinksDir((AbstractItem)build.getProject()));
        try {
            docLinksDir.deleteRecursive();
            for (Document doc : this.documents) {
                DocLinksUtils.publishDocument((Document)doc, (FilePath)ws, (FilePath)docLinksDir, (PrintStream)logger);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        return true;
    }
}

