/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks.m2;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.doclinks.Document;
import hudson.plugins.doclinks.m2.DocLinksMavenAction;
import hudson.plugins.doclinks.m2.DocLinksMavenReporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DocLinksMavenReporter
extends MavenReporter {
    private static final long serialVersionUID = 1L;
    public static final MavenReporterDescriptor DESCRIPTOR = new DocLinksMavenReporterDescriptor();
    private final List<Document> documents;
    private static final Logger LOGGER = Logger.getLogger(DocLinksMavenReporter.class.getName());

    public DocLinksMavenReporter(List<Document> docs) {
        this.documents = docs;
    }

    public static File getDocLinksDir(MavenModule module) {
        return new File(module.getRootDir(), "doclinks");
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public Action getProjectAction(MavenModule module) {
        LinkedHashMap<String, Document> map = new LinkedHashMap<String, Document>();
        for (Document doc : this.documents) {
            map.put(doc.getId(), doc);
        }
        return new DocLinksMavenAction(module, map);
    }

    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        FilePath ws = build.getWorkspace();
        FilePath docLinksDir = new FilePath(DocLinksMavenReporter.getDocLinksDir((MavenModule)build.getParent()));
        try {
            docLinksDir.deleteRecursive();
            for (Document doc : this.documents) {
                doc.publish(ws, docLinksDir, logger);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.UNSTABLE);
            return true;
        }
        build.registerAsProjectAction((MavenReporter)this);
        return true;
    }
}

