/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doclinks;

import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.plugins.doclinks.DocLinksPublisher;
import hudson.plugins.doclinks.DocLinksUtils;
import hudson.plugins.doclinks.Messages;
import hudson.plugins.doclinks.m2.DocLinksMavenReporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class Document
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String description;
    private final String directory;
    private final boolean recursive;
    private final String file;
    private String id;

    @DataBoundConstructor
    public Document(String title, String description, String directory, boolean recursive, String file, String id) {
        this.title = Util.fixEmptyAndTrim((String)title);
        this.description = Util.fixEmptyAndTrim((String)description);
        this.directory = Util.fixEmptyAndTrim((String)directory);
        this.recursive = recursive;
        this.file = Util.fixEmptyAndTrim((String)file);
        this.id = Util.fixEmptyAndTrim((String)id);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String getFile() {
        return this.file;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasResources(AbstractItem project) {
        File docLinksDir = DocLinksPublisher.getDocLinksDir(project);
        return this.isDocumentExits(docLinksDir);
    }

    public boolean hasResources(MavenModule module) {
        File docLinksDir = DocLinksMavenReporter.getDocLinksDir(module);
        return this.isDocumentExits(docLinksDir);
    }

    public void publish(FilePath origin, FilePath dest, PrintStream logger) throws IOException, InterruptedException {
        FilePath docDir;
        String dir = this.getDirectory();
        if (!DocLinksUtils.isValidDirectory(dir)) {
            String cause = Messages.DocLinksUtils_DirectoryInvalid();
            DocLinksUtils.log(logger, Messages.Document_SkipDocument(this.getTitle(), cause));
            throw new IOException("directory is invalid.");
        }
        FilePath filePath = docDir = dir != null ? origin.child(dir) : origin;
        if (!docDir.exists()) {
            String cause = Messages.DocLinksUtils_DirectoryNotExist(docDir.getName());
            DocLinksUtils.log(logger, Messages.Document_SkipDocument(this.getTitle(), cause));
            throw new IOException("docDir does not exist.");
        }
        FilePath targetDir = new FilePath(dest, String.valueOf(this.getId()));
        DocLinksUtils.log(logger, Messages.Document_CopyDocument(this.getTitle(), targetDir.getName()));
        if (this.isRecursive()) {
            docDir.copyRecursiveTo("**/*", targetDir);
        } else {
            docDir.copyRecursiveTo("*", targetDir);
        }
    }

    private boolean isDocumentExits(File docLinksDir) {
        File docDir = new File(docLinksDir, String.valueOf(this.getId()));
        if (this.file == null) {
            return docDir.exists();
        }
        File indexFile = new File(docDir, this.file);
        return indexFile.exists();
    }
}

