/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.AbstractDownstreamBuildViewAction;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamBuildViewPublisher
extends Recorder {
    private static final Logger log = Logger.getLogger(DownstreamBuildViewPublisher.class.getName());
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        build.addAction((Action)new DownstreamBuildViewAction(build));
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private boolean enable = true;

        public boolean isEnable() {
            return this.enable;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return this.enable;
        }

        public String getDisplayName() {
            return "Downstream Build view";
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.enable = json.getBoolean("enable");
            this.save();
            return true;
        }

        public String getHelpFile() {
            return "/help/downstream-help-globalConfig.html";
        }

        public DownstreamBuildViewPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new DownstreamBuildViewPublisher();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DownstreamBuildViewAction
    extends AbstractDownstreamBuildViewAction {
        private List<DownstreamBuilds> downstreamBuildList;

        public DownstreamBuildViewAction(AbstractBuild<?, ?> build) {
            super(build);
            BuildTrigger buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class);
            if (buildTrigger != null) {
                List childs = buildTrigger.getChildProjects();
                this.downstreamBuildList = this.findDownstream(childs, 1, new ArrayList<Integer>());
            }
        }

        private List<DownstreamBuilds> findDownstream(List<AbstractProject> childs, int depth, List<Integer> parentChildSize) {
            ArrayList<DownstreamBuilds> childList = new ArrayList<DownstreamBuilds>();
            for (AbstractProject project : childs) {
                DownstreamBuilds downstreamBuild = new DownstreamBuilds();
                downstreamBuild.setProjectName(project.getName());
                downstreamBuild.setProjectUrl(project.getUrl());
                downstreamBuild.setBuildNumber(Integer.toString(project.getNextBuildNumber()));
                downstreamBuild.setRootURL(Hudson.getInstance().getRootUrl());
                downstreamBuild.setDepth(depth);
                if (parentChildSize.size() <= depth) {
                    parentChildSize.add(childs.size());
                }
                downstreamBuild.setParentChildSize(parentChildSize);
                downstreamBuild.setChildNumber(childs.size());
                List childProjects = project.getDownstreamProjects();
                if (!childProjects.isEmpty()) {
                    downstreamBuild.setChilds(this.findDownstream(childProjects, depth + 1, parentChildSize));
                }
                childList.add(downstreamBuild);
            }
            return childList;
        }

        public List getDownstreamBuildList() {
            return this.downstreamBuildList;
        }

        public void setDownstreamBuildList(List downstreamBuildList) {
            this.downstreamBuildList = downstreamBuildList;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DownstreamBuilds {
            private String projectName;
            private String projectUrl;
            private String buildNumber;
            private String imageUrl;
            private String rootURL;
            private String statusMessage;
            private List<DownstreamBuilds> childs;
            private int depth;
            private int childNumber;
            private List<Integer> parentChildSize;

            public List<Integer> getParentChildSize() {
                return this.parentChildSize;
            }

            public void setParentChildSize(List<Integer> parentChildSize) {
                this.parentChildSize = parentChildSize;
            }

            public String getProjectName() {
                return this.projectName;
            }

            public void setProjectName(String projectName) {
                this.projectName = projectName;
            }

            public String getProjectUrl() {
                return this.projectUrl;
            }

            public void setProjectUrl(String projectUrl) {
                this.projectUrl = projectUrl;
            }

            public String getBuildNumber() {
                return this.buildNumber;
            }

            public int getDepth() {
                return this.depth;
            }

            public void setBuildNumber(String buildNumber) {
                this.buildNumber = buildNumber;
            }

            public int getChildNumber() {
                return this.childNumber;
            }

            public void setChildNumber(int childNumber) {
                this.childNumber = childNumber;
            }

            public String getImageUrl() {
                AbstractProject proj = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectName, AbstractProject.class);
                Run r = proj.getBuildByNumber(Integer.parseInt(this.buildNumber));
                return this.rootURL + "images/16x16/" + this.getIconName(r);
            }

            public void setImageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
            }

            public List<DownstreamBuilds> getChilds() {
                return this.childs;
            }

            public void setChilds(List<DownstreamBuilds> childs) {
                this.childs = childs;
            }

            public String getRootURL() {
                return this.rootURL;
            }

            public void setRootURL(String rootURL) {
                this.rootURL = rootURL;
            }

            public void setDepth(int depth) {
                this.depth = depth;
            }

            public String getIconName(Run r) {
                return r.getIconColor().getImage();
            }

            public String getStatusMessage() {
                AbstractProject proj = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectName, AbstractProject.class);
                Run r = proj.getBuildByNumber(Integer.parseInt(this.buildNumber));
                if (r.isBuilding()) {
                    return r.getDurationString();
                }
                return r.getTimestamp().getTime().toString();
            }

            public void setStatusMessage(String statusMessage) {
                this.statusMessage = statusMessage;
            }
        }
    }
}

