/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.tasks.BuildTrigger;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hudson.plugins.AbstractDownstreamBuildViewAction;
import org.jvnet.hudson.plugins.DownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamBuildViewAction
extends AbstractDownstreamBuildViewAction {
    private List<DownstreamBuilds> downstreamBuildList;

    public DownstreamBuildViewAction(AbstractBuild<?, ?> build) {
        super(build);
        BuildTrigger buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            this.downstreamBuildList = this.findDownstream(childs, 1, new ArrayList());
        }
    }

    private List<DownstreamBuilds> findDownstream(List<AbstractProject> childs, int depth, List<Integer> parentChildSize) {
        ArrayList<DownstreamBuilds> childList = new ArrayList<DownstreamBuilds>();
        for (AbstractProject project : childs) {
            DownstreamBuilds downstreamBuild = new DownstreamBuilds(this);
            downstreamBuild.setProjectName(project.getName());
            downstreamBuild.setProjectUrl(project.getUrl());
            downstreamBuild.setBuildNumber(Integer.toString(project.getNextBuildNumber()));
            downstreamBuild.setRootURL(Hudson.getInstance().getRootUrl());
            downstreamBuild.setDepth(depth);
            if (parentChildSize.size() <= depth) {
                parentChildSize.add(childs.size());
            }
            downstreamBuild.setParentChildSize(parentChildSize);
            downstreamBuild.setChildNumber(childs.size());
            List childProjects = project.getDownstreamProjects();
            if (!childProjects.isEmpty()) {
                downstreamBuild.setChilds(this.findDownstream(childProjects, depth + 1, parentChildSize));
            }
            childList.add(downstreamBuild);
        }
        return childList;
    }

    public List getDownstreamBuildList() {
        return this.downstreamBuildList;
    }

    public void setDownstreamBuildList(List downstreamBuildList) {
        this.downstreamBuildList = downstreamBuildList;
    }
}

