/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.DownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownstreamBuildViewRunListener
extends RunListener<AbstractBuild>
implements Saveable {
    private static final Logger LOG = Logger.getLogger(DownstreamBuildViewRunListener.class.getName());
    private AbstractBuild<?, ?> build;

    public DownstreamBuildViewRunListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        this.build = r;
        DownstreamBuildViewAction downstreamBuildViewAction = new DownstreamBuildViewAction((AbstractBuild<?, ?>)r);
        r.addAction((Action)downstreamBuildViewAction);
        LOG.info(r.toString() + ":" + r.getActions().toString());
        LOG.info("Registering " + downstreamBuildViewAction.getDisplayName() + " for " + r);
        super.onFinalized((Run)r);
        this.save();
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write(this.build);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOG.info("Failed to save ");
        }
    }

    private XmlFile getConfigFile() {
        AbstractBuild<?, ?> r = this.build;
        return new XmlFile(Run.XSTREAM, new File(r.getRootDir(), "build.xml"));
    }
}

