/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildTrigger;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hudson.plugins.AbstractDownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamBuildViewAction
extends AbstractDownstreamBuildViewAction {
    private List<DownstreamBuilds> downstreamBuildList;
    private transient String rootURL;

    public DownstreamBuildViewAction(AbstractBuild<?, ?> build) {
        super(build);
        BuildTrigger buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            this.downstreamBuildList = this.findDownstream(childs, 1, new ArrayList<Integer>());
        }
        this.rootURL = Hudson.getInstance().getRootUrl();
    }

    private List<DownstreamBuilds> findDownstream(List<AbstractProject> childs, int depth, List<Integer> parentChildSize) {
        ArrayList<DownstreamBuilds> childList = new ArrayList<DownstreamBuilds>();
        for (AbstractProject project : childs) {
            DownstreamBuilds downstreamBuild = new DownstreamBuilds();
            downstreamBuild.setProjectName(project.getName());
            downstreamBuild.setProjectUrl(project.getUrl());
            downstreamBuild.setBuildNumber(Integer.toString(project.getNextBuildNumber()));
            downstreamBuild.setDepth(depth);
            if (parentChildSize.size() <= depth) {
                parentChildSize.add(childs.size());
            }
            downstreamBuild.setParentChildSize(parentChildSize);
            downstreamBuild.setChildNumber(childs.size());
            List childProjects = project.getDownstreamProjects();
            if (!childProjects.isEmpty()) {
                downstreamBuild.setChilds(this.findDownstream(childProjects, depth + 1, parentChildSize));
            }
            childList.add(downstreamBuild);
        }
        return childList;
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public List<DownstreamBuilds> getDownstreamBuildList() {
        return this.downstreamBuildList;
    }

    public void setDownstreamBuildList(List<DownstreamBuilds> downstreamBuildList) {
        this.downstreamBuildList = downstreamBuildList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DownstreamBuilds {
        private String projectName;
        private String projectUrl;
        private String buildNumber;
        private List<DownstreamBuilds> childs;
        private int depth;
        private int childNumber;
        private List<Integer> parentChildSize;

        public List<Integer> getParentChildSize() {
            return this.parentChildSize;
        }

        public void setParentChildSize(List<Integer> parentChildSize) {
            this.parentChildSize = parentChildSize;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectUrl() {
            return this.projectUrl;
        }

        public void setProjectUrl(String projectUrl) {
            this.projectUrl = projectUrl;
        }

        public String getRootURL() {
            return DownstreamBuildViewAction.this.rootURL;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
        }

        public int getChildNumber() {
            return this.childNumber;
        }

        public void setChildNumber(int childNumber) {
            this.childNumber = childNumber;
        }

        public String getImageUrl() {
            AbstractProject proj = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectName, AbstractProject.class);
            Run r = proj.getBuildByNumber(Integer.parseInt(this.buildNumber));
            return this.getIconName(r);
        }

        public List<DownstreamBuilds> getChilds() {
            return this.childs;
        }

        public void setChilds(List<DownstreamBuilds> childs) {
            this.childs = childs;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public String getIconName(Run<?, ?> r) {
            if (r == null || r.isBuilding()) {
                return BallColor.GREY.anime().getImage();
            }
            return r.getResult().color.getImage();
        }

        public String getStatusMessage() {
            AbstractProject proj = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectName, AbstractProject.class);
            Run r = proj.getBuildByNumber(Integer.parseInt(this.buildNumber));
            if (r == null) {
                return Result.NOT_BUILT.toString();
            }
            if (r.isBuilding()) {
                return r.getDurationString();
            }
            return r.getTimestamp().getTime().toString() + " - " + r.getResult().toString();
        }
    }
}

