/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.tasks.BuildTrigger;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hudson.plugins.AbstractDownstreamBuildViewAction;
import org.jvnet.hudson.plugins.DownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamBuildViewAction
extends AbstractDownstreamBuildViewAction {
    private transient List<DownstreamBuilds> downstreamBuildList;
    private transient String rootURL;
    private static final transient String NOT_BUILT_NUMBER = "</a>#0000<a>";

    public DownstreamBuildViewAction(AbstractBuild<?, ?> build) {
        super(build);
        BuildTrigger buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            for (AbstractProject project : childs) {
                this.addDownstreamBuilds(project.getName(), 0);
            }
        }
        this.rootURL = Hudson.getInstance().getRootUrl();
    }

    private List<DownstreamBuilds> findDownstream(List<AbstractProject> childs, int depth, List<Integer> parentChildSize, String upProjectName, int upBuildNumber) {
        ArrayList<DownstreamBuilds> childList = new ArrayList<DownstreamBuilds>();
        for (AbstractProject project : childs) {
            DownstreamBuilds downstreamBuild = new DownstreamBuilds(this);
            downstreamBuild.setProjectName(project.getName());
            downstreamBuild.setProjectUrl(project.getUrl());
            AbstractProject upproject = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            if (upBuildNumber != 0) {
                AbstractBuild upBuild = (AbstractBuild)upproject.getBuildByNumber(upBuildNumber);
                if (upBuild != null) {
                    for (DownstreamBuildViewAction action : upBuild.getActions(DownstreamBuildViewAction.class)) {
                        downstreamBuild.setBuildNumber(action.getDownstreamBuildNumber(project.getName()));
                    }
                } else {
                    downstreamBuild.setBuildNumber(0);
                }
            } else {
                downstreamBuild.setBuildNumber(0);
            }
            downstreamBuild.setDepth(depth);
            if (parentChildSize.size() <= depth) {
                parentChildSize.add(childs.size());
            }
            downstreamBuild.setParentChildSize(parentChildSize);
            downstreamBuild.setChildNumber(childs.size());
            List childProjects = project.getDownstreamProjects();
            if (!childProjects.isEmpty()) {
                downstreamBuild.setChilds(this.findDownstream(childProjects, depth + 1, parentChildSize, project.getName(), downstreamBuild.getBuildNumber()));
            }
            childList.add(downstreamBuild);
        }
        return childList;
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public List<DownstreamBuilds> getDownstreamBuildList() {
        BuildTrigger buildTrigger = (BuildTrigger)this.build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            this.downstreamBuildList = this.findDownstream(childs, 1, new ArrayList(), ((AbstractProject)this.build.getParent()).getName(), this.build.getNumber());
        }
        return this.downstreamBuildList;
    }

    public void setDownstreamBuildList(List<DownstreamBuilds> downstreamBuildList) {
        this.downstreamBuildList = downstreamBuildList;
    }

    static /* synthetic */ String access$000(DownstreamBuildViewAction x0) {
        return x0.rootURL;
    }
}

