/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildTrigger;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hudson.plugins.AbstractDownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamBuildViewAction
extends AbstractDownstreamBuildViewAction {
    private transient List<DownstreamBuilds> downstreamBuildList;
    private transient String rootURL;
    private static final transient String NOT_BUILT_NUMBER = "</a>#0000<a>";

    public DownstreamBuildViewAction(AbstractBuild<?, ?> build) {
        super(build);
        BuildTrigger buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            for (AbstractProject project : childs) {
                this.addDownstreamBuilds(project.getName(), 0);
            }
        }
        this.rootURL = Hudson.getInstance().getRootUrl();
    }

    private List<DownstreamBuilds> findDownstream(List<AbstractProject> childs, int depth, List<Integer> parentChildSize, String upProjectName, int upBuildNumber) {
        ArrayList<DownstreamBuilds> childList = new ArrayList<DownstreamBuilds>();
        for (AbstractProject project : childs) {
            DownstreamBuilds downstreamBuild = new DownstreamBuilds();
            downstreamBuild.setProjectName(project.getName());
            downstreamBuild.setProjectUrl(project.getUrl());
            AbstractProject upproject = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            if (upBuildNumber != 0) {
                AbstractBuild upBuild = (AbstractBuild)upproject.getBuildByNumber(upBuildNumber);
                if (upBuild != null) {
                    for (DownstreamBuildViewAction action : upBuild.getActions(DownstreamBuildViewAction.class)) {
                        downstreamBuild.setBuildNumber(action.getDownstreamBuildNumber(project.getName()));
                    }
                } else {
                    downstreamBuild.setBuildNumber(0);
                }
            } else {
                downstreamBuild.setBuildNumber(0);
            }
            downstreamBuild.setDepth(depth);
            if (parentChildSize.size() <= depth) {
                parentChildSize.add(childs.size());
            }
            downstreamBuild.setParentChildSize(parentChildSize);
            downstreamBuild.setChildNumber(childs.size());
            List childProjects = project.getDownstreamProjects();
            if (!childProjects.isEmpty()) {
                downstreamBuild.setChilds(this.findDownstream(childProjects, depth + 1, parentChildSize, project.getName(), downstreamBuild.getBuildNumber()));
            }
            childList.add(downstreamBuild);
        }
        return childList;
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public List<DownstreamBuilds> getDownstreamBuildList() {
        BuildTrigger buildTrigger = (BuildTrigger)this.build.getProject().getPublishersList().get(BuildTrigger.class);
        if (buildTrigger != null) {
            List childs = buildTrigger.getChildProjects();
            this.downstreamBuildList = this.findDownstream(childs, 1, new ArrayList<Integer>(), ((AbstractProject)this.build.getParent()).getName(), this.build.getNumber());
        }
        return this.downstreamBuildList;
    }

    public void setDownstreamBuildList(List<DownstreamBuilds> downstreamBuildList) {
        this.downstreamBuildList = downstreamBuildList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DownstreamBuilds {
        private String projectName;
        private String projectUrl;
        private String upProjectName;
        private List<DownstreamBuilds> childs;
        private int depth;
        private int childNumber;
        private int buildNumber;
        private int upBuildNumber;
        private List<Integer> parentChildSize;
        private transient AbstractProject project;
        private transient Run<?, ?> run;

        private void initilize() {
            this.project = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectName, AbstractProject.class);
            this.run = this.project.getBuildByNumber(this.buildNumber);
        }

        public List<Integer> getParentChildSize() {
            return this.parentChildSize;
        }

        public void setParentChildSize(List<Integer> parentChildSize) {
            this.parentChildSize = parentChildSize;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectUrl() {
            return this.projectUrl;
        }

        public void setProjectUrl(String projectUrl) {
            this.projectUrl = projectUrl;
        }

        public String getRootURL() {
            return DownstreamBuildViewAction.this.rootURL;
        }

        public int getBuildNumber() {
            return this.buildNumber;
        }

        public String currentBuildNumber() {
            if (this.buildNumber == 0) {
                return DownstreamBuildViewAction.NOT_BUILT_NUMBER;
            }
            return Integer.toString(this.buildNumber);
        }

        public int getDepth() {
            return this.depth;
        }

        public void setBuildNumber(int buildNumber) {
            this.buildNumber = buildNumber;
        }

        public int getChildNumber() {
            return this.childNumber;
        }

        public void setChildNumber(int childNumber) {
            this.childNumber = childNumber;
        }

        public String getImageUrl() {
            if (this.run == null) {
                this.initilize();
            }
            if (this.run == null || this.run.isBuilding()) {
                return BallColor.GREY.anime().getImage();
            }
            return this.run.getResult().color.getImage();
        }

        public List<DownstreamBuilds> getChilds() {
            return this.childs;
        }

        public void setChilds(List<DownstreamBuilds> childs) {
            this.childs = childs;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public String getStatusMessage() {
            if (this.project == null) {
                this.initilize();
            }
            if (this.run == null) {
                return Result.NOT_BUILT.toString();
            }
            if (this.run.isBuilding()) {
                return this.run.getDurationString();
            }
            return this.run.getTimestamp().getTime().toString() + " - " + this.run.getResult().toString();
        }

        public String getUpProjectName() {
            return this.upProjectName;
        }

        public void setUpProjectName(String upProjectName) {
            this.upProjectName = upProjectName;
        }

        public int getUpBuildNumber() {
            return this.upBuildNumber;
        }

        public void setUpBuildNumber(int upBuildNumber) {
            this.upBuildNumber = upBuildNumber;
        }
    }
}

