/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.DownstreamBuildViewAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownstreamBuildViewUpdateListener
extends RunListener<AbstractBuild>
implements Saveable {
    private static final Logger LOG = Logger.getLogger(DownstreamBuildViewUpdateListener.class.getName());
    private AbstractBuild<?, ?> build;

    public DownstreamBuildViewUpdateListener() {
        super(AbstractBuild.class);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
        CauseAction ca = (CauseAction)r.getAction(CauseAction.class);
        if (ca == null || ca.getCauses() == null) {
            return;
        }
        for (Cause c : ca.getCauses()) {
            AbstractBuild upBuild;
            if (!(c instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause upcause = (Cause.UpstreamCause)c;
            String upProjectName = upcause.getUpstreamProject();
            int buildNumber = upcause.getUpstreamBuild();
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            this.build = upBuild = (AbstractBuild)project.getBuildByNumber(buildNumber);
            for (DownstreamBuildViewAction action : upBuild.getActions(DownstreamBuildViewAction.class)) {
                action.addDownstreamBuilds(r.getProject().getName(), r.getNumber());
            }
            super.onFinalized(this.build);
            this.save();
        }
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write(this.build);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOG.info("Failed to save ");
        }
    }

    private XmlFile getConfigFile() {
        AbstractBuild<?, ?> r = this.build;
        return new XmlFile(Run.XSTREAM, new File(r.getRootDir(), "build.xml"));
    }
}

