/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.downstream_ext.Messages;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamTrigger
extends Recorder
implements DependecyDeclarer,
MatrixAggregatable {
    private String childProjects;
    private final Result threshold;
    private final boolean onlyIfSCMChanges;
    private static final Logger LOGGER = Logger.getLogger(DownstreamTrigger.class.getName());

    @DataBoundConstructor
    public DownstreamTrigger(String childProjects, boolean evenIfUnstable, boolean onlyIfSCMChanges) {
        this(childProjects, evenIfUnstable ? Result.UNSTABLE : Result.SUCCESS, onlyIfSCMChanges);
    }

    public DownstreamTrigger(String childProjects, Result threshold, boolean onlyIfSCMChanges) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
        this.onlyIfSCMChanges = onlyIfSCMChanges;
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    public boolean isOnlyIfSCMChanges() {
        return this.onlyIfSCMChanges;
    }

    public List<AbstractProject> getChildProjects() {
        return Items.fromNameList((String)this.childProjects, AbstractProject.class);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        if (build.getResult().isBetterOrEqualTo(this.getThreshold())) {
            PrintStream logger = listener.getLogger();
            List<AbstractProject> downstreamProjects = this.getChildProjects();
            for (AbstractProject p : downstreamProjects) {
                if (p.isDisabled()) {
                    logger.println(hudson.tasks.Messages.BuildTrigger_Disabled((Object)p.getName()));
                    continue;
                }
                if (this.isOnlyIfSCMChanges() && !p.pollSCMChanges((TaskListener)listener)) {
                    logger.println(Messages.DownstreamTrigger_NoSCMChanges(p.getName()));
                    continue;
                }
                String name = p.getName() + " #" + p.getNextBuildNumber();
                if (p.scheduleBuild((Cause)new Cause.UpstreamCause((Run)build))) {
                    logger.println(hudson.tasks.Messages.BuildTrigger_Triggering((Object)name));
                    continue;
                }
                logger.println(hudson.tasks.Messages.BuildTrigger_InQueue((Object)name));
            }
        }
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return DownstreamTrigger.this.perform((AbstractBuild)this.build, this.launcher, this.listener);
            }
        };
    }

    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        String[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder b = new StringBuilder();
            for (String p : projects) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(p);
            }
            this.childProjects = b.toString();
        }
        return changed;
    }

    private Object readResolve() {
        if (this.childProjects == null) {
            this.childProjects = "";
            return "";
        }
        return this;
    }

    public static class DescriptorImpl
    extends BuildTrigger.DescriptorImpl {
        public String getDisplayName() {
            return Messages.DownstreamTrigger_DisplayName();
        }

        public String getHelpFile() {
            return "/help/project-config/downstream.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DownstreamTrigger(formData.getString("childProjects"), formData.has("evenIfUnstable") && formData.getBoolean("evenIfUnstable"), formData.has("onlyIfSCMChanges") && formData.getBoolean("onlyIfSCMChanges"));
        }

        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    DownstreamTrigger t = (DownstreamTrigger)p.getPublishersList().get(DownstreamTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }
    }
}

