/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import hudson.plugins.downstream_ext.DownstreamTrigger;
import hudson.plugins.downstream_ext.Messages;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamDependency
extends DependencyGraph.Dependency {
    private final DownstreamTrigger trigger;

    public DownstreamDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, DownstreamTrigger trigger) {
        super(upstream, downstream);
        this.trigger = trigger;
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        PrintStream logger = listener.getLogger();
        if (this.trigger.getStrategy().evaluate(this.trigger.getThreshold(), build.getResult())) {
            AbstractProject p = this.getDownstreamProject();
            if (this.trigger.isOnlyIfSCMChanges()) {
                if (p.getScm().requiresWorkspaceForPolling()) {
                    logger.println(Messages.DownstreamTrigger_StartedAsynchPoll(p.getName()));
                    p.schedulePolling();
                    return false;
                }
                if (p.pollSCMChanges(listener)) {
                    return true;
                }
                logger.println(Messages.DownstreamTrigger_NoSCMChanges(p.getName()));
                return false;
            }
            return true;
        }
        logger.println(Messages.DownstreamTrigger_ConditionNotMet(this.trigger.getStrategy().getDisplayName(), this.trigger.getThreshold()));
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DownstreamDependency)) {
            return false;
        }
        return super.equals(obj);
    }
}

