// CHECKSTYLE:OFF

package hudson.plugins.downstream_ext;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Build other projects (extended)
     * 
     */
    public static String DownstreamTrigger_DisplayName() {
        return holder.format("DownstreamTrigger.DisplayName");
    }

    /**
     * Build other projects (extended)
     * 
     */
    public static Localizable _DownstreamTrigger_DisplayName() {
        return new Localizable(holder, "DownstreamTrigger.DisplayName");
    }

    /**
     * Condition: ''build result {0} {1}'' not met. Triggering skipped.
     * 
     */
    public static String DownstreamTrigger_ConditionNotMet(Object arg1, Object arg2) {
        return holder.format("DownstreamTrigger.ConditionNotMet", arg1, arg2);
    }

    /**
     * Condition: ''build result {0} {1}'' not met. Triggering skipped.
     * 
     */
    public static Localizable _DownstreamTrigger_ConditionNotMet(Object arg1, Object arg2) {
        return new Localizable(holder, "DownstreamTrigger.ConditionNotMet", arg1, arg2);
    }

    /**
     * Scheduled an asynchronous SCM poll for {0}. Project will be started later if applicable. 
     * 
     */
    public static String DownstreamTrigger_StartedAsynchPoll(Object arg1) {
        return holder.format("DownstreamTrigger.StartedAsynchPoll", arg1);
    }

    /**
     * Scheduled an asynchronous SCM poll for {0}. Project will be started later if applicable. 
     * 
     */
    public static Localizable _DownstreamTrigger_StartedAsynchPoll(Object arg1) {
        return new Localizable(holder, "DownstreamTrigger.StartedAsynchPoll", arg1);
    }

    /**
     * {0} has no SCM changes. Triggering skipped.
     * 
     */
    public static String DownstreamTrigger_NoSCMChanges(Object arg1) {
        return holder.format("DownstreamTrigger.NoSCMChanges", arg1);
    }

    /**
     * {0} has no SCM changes. Triggering skipped.
     * 
     */
    public static Localizable _DownstreamTrigger_NoSCMChanges(Object arg1) {
        return new Localizable(holder, "DownstreamTrigger.NoSCMChanges", arg1);
    }

}
