/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.listeners.ItemListener;
import hudson.plugins.downstream_ext.DownstreamDependency;
import hudson.plugins.downstream_ext.Messages;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamTrigger
extends Notifier
implements DependecyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(DownstreamTrigger.class.getName());
    private String childProjects;
    private Result threshold = Result.SUCCESS;
    private Strategy thresholdStrategy;
    private final boolean onlyIfSCMChanges;

    @DataBoundConstructor
    public DownstreamTrigger(String childProjects, String threshold, boolean onlyIfSCMChanges, String strategy) {
        this(childProjects, DownstreamTrigger.resultFromString(threshold), onlyIfSCMChanges, Strategy.valueOf(strategy));
    }

    public DownstreamTrigger(String childProjects, Result threshold, boolean onlyIfSCMChanges, Strategy strategy) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
        this.onlyIfSCMChanges = onlyIfSCMChanges;
        this.thresholdStrategy = strategy;
    }

    private static Result resultFromString(String s) {
        Result result = Result.fromString((String)s);
        if (!result.toString().equals(s)) {
            throw new IllegalArgumentException("Unknown result type '" + s + "'");
        }
        return result;
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    public boolean isOnlyIfSCMChanges() {
        return this.onlyIfSCMChanges;
    }

    public List<AbstractProject> getChildProjects() {
        return Items.fromNameList((String)this.childProjects, AbstractProject.class);
    }

    public Strategy getStrategy() {
        return this.thresholdStrategy;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (AbstractProject downstream : this.getChildProjects()) {
            graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency(owner, downstream, this));
        }
        if (owner instanceof MatrixProject) {
            MatrixProject proj = (MatrixProject)owner;
            Collection activeConfigurations = proj.getActiveConfigurations();
            for (MatrixConfiguration conf : activeConfigurations) {
                for (AbstractProject downstream : this.getChildProjects()) {
                    graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency((AbstractProject<?, ?>)conf, (AbstractProject<?, ?>)downstream, this));
                }
            }
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        String[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder b = new StringBuilder();
            for (String p : projects) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(p);
            }
            this.childProjects = b.toString();
        }
        return changed;
    }

    private Object readResolve() {
        if (this.thresholdStrategy == null) {
            this.thresholdStrategy = Strategy.AND_HIGHER;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        AND_HIGHER("equal or over"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.isBetterOrEqualTo(threshold);
            }
        }
        ,
        EXACT("equal"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.equals(threshold);
            }
        }
        ,
        AND_LOWER("equal or under"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.isWorseOrEqualTo(threshold);
            }
        };

        public final String displayName;

        private Strategy(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract boolean evaluate(Result var1, Result var2);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTrigger.DescriptorImpl {
        public static final String[] THRESHOLD_VALUES = new String[]{Result.SUCCESS.toString(), Result.UNSTABLE.toString(), Result.FAILURE.toString(), Result.ABORTED.toString()};
        public static final Strategy[] STRATEGY_VALUES = Strategy.values();

        public String getDisplayName() {
            return Messages.DownstreamTrigger_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/downstream-ext/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DownstreamTrigger(formData.getString("childProjects"), formData.getString("threshold"), formData.has("onlyIfSCMChanges") && formData.getBoolean("onlyIfSCMChanges"), formData.getString("strategy"));
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    DownstreamTrigger t = (DownstreamTrigger)p.getPublishersList().get(DownstreamTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }
    }
}

