/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Items;
import hudson.model.Result;
import hudson.plugins.downstream_ext.DownstreamDependency;
import hudson.plugins.downstream_ext.DownstreamTrigger;
import hudson.plugins.downstream_ext.MatrixTrigger;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DownstreamTrigger
extends Notifier
implements DependecyDeclarer,
MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(DownstreamTrigger.class.getName());
    private String childProjects;
    private Result threshold = Result.SUCCESS;
    private Strategy thresholdStrategy;
    private final boolean onlyIfSCMChanges;
    @Deprecated
    private transient Boolean triggerOnlyOnceWhenMatrixEnds;
    private MatrixTrigger matrixTrigger;
    private static final ConcurrentHashMap<AbstractProject<?, ?>, Executor> executors = new ConcurrentHashMap();

    @DataBoundConstructor
    public DownstreamTrigger(String childProjects, String threshold, boolean onlyIfSCMChanges, String strategy, String matrixTrigger) {
        this(childProjects, DownstreamTrigger.resultFromString((String)threshold), onlyIfSCMChanges, Strategy.valueOf((String)strategy), matrixTrigger != null ? MatrixTrigger.valueOf((String)matrixTrigger) : null);
    }

    public DownstreamTrigger(String childProjects, Result threshold, boolean onlyIfSCMChanges, Strategy strategy, MatrixTrigger matrixTrigger) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
        this.onlyIfSCMChanges = onlyIfSCMChanges;
        this.thresholdStrategy = strategy;
        this.matrixTrigger = matrixTrigger;
    }

    private static Result resultFromString(String s) {
        Result result = Result.fromString((String)s);
        if (!result.toString().equals(s)) {
            throw new IllegalArgumentException("Unknown result type '" + s + "'");
        }
        return result;
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    public boolean isOnlyIfSCMChanges() {
        return this.onlyIfSCMChanges;
    }

    public MatrixTrigger getMatrixTrigger() {
        return this.matrixTrigger;
    }

    public List<AbstractProject> getChildProjects() {
        return Items.fromNameList((String)this.childProjects, AbstractProject.class);
    }

    public Strategy getStrategy() {
        return this.thresholdStrategy;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (AbstractProject downstream : this.getChildProjects()) {
            graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency(owner, downstream, this));
        }
        if (this.matrixTrigger != null && (this.matrixTrigger == MatrixTrigger.ONLY_CONFIGURATIONS || this.matrixTrigger == MatrixTrigger.BOTH) && owner instanceof MatrixProject) {
            MatrixProject proj = (MatrixProject)owner;
            Collection activeConfigurations = proj.getActiveConfigurations();
            for (MatrixConfiguration conf : activeConfigurations) {
                for (AbstractProject downstream : this.getChildProjects()) {
                    graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency((AbstractProject)conf, downstream, this));
                }
            }
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        String[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder b = new StringBuilder();
            for (String p : projects) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(p);
            }
            this.childProjects = b.toString();
        }
        return changed;
    }

    public static void executeForProject(AbstractProject<?, ?> project, Runnable run) {
        Executor old;
        Executor executor = (Executor)executors.get(project);
        if (executor == null && (old = executors.putIfAbsent(project, executor = Executors.newSingleThreadExecutor())) != null) {
            executor = old;
        }
        executor.execute(run);
    }

    private Object readResolve() {
        if (this.thresholdStrategy == null) {
            this.thresholdStrategy = Strategy.AND_HIGHER;
        }
        if (this.triggerOnlyOnceWhenMatrixEnds != null) {
            this.matrixTrigger = this.triggerOnlyOnceWhenMatrixEnds != false ? MatrixTrigger.ONLY_PARENT : MatrixTrigger.ONLY_CONFIGURATIONS;
        }
        return this;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ ConcurrentHashMap access$100() {
        return executors;
    }

    static /* synthetic */ MatrixTrigger access$300(DownstreamTrigger x0) {
        return x0.matrixTrigger;
    }
}

