/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.downstream_ext.DownstreamTrigger;
import hudson.plugins.downstream_ext.Messages;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamDependency
extends DependencyGraph.Dependency {
    private static final Logger LOGGER = Logger.getLogger(DownstreamDependency.class.getName());
    private final DownstreamTrigger trigger;

    public DownstreamDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, DownstreamTrigger trigger) {
        super(upstream, downstream);
        this.trigger = trigger;
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        PrintStream logger = listener.getLogger();
        if (this.trigger.getStrategy().evaluate(this.trigger.getThreshold(), build.getResult())) {
            AbstractProject p = this.getDownstreamProject();
            if (this.trigger.isOnlyIfSCMChanges()) {
                if (p.getScm().requiresWorkspaceForPolling()) {
                    logger.println(Messages.DownstreamTrigger_StartedAsynchPoll(p.getName()));
                    Runnable run = this.getPoller(p, (Cause)new Cause.UpstreamCause((Run)build), actions);
                    DownstreamTrigger.executeForProject(p, run);
                    return false;
                }
                if (p.pollSCMChanges(listener)) {
                    return true;
                }
                logger.println(Messages.DownstreamTrigger_NoSCMChanges(p.getName()));
                return false;
            }
            return true;
        }
        logger.println(Messages.DownstreamTrigger_ConditionNotMet(this.trigger.getStrategy().getDisplayName(), this.trigger.getThreshold()));
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DownstreamDependency)) {
            return false;
        }
        return super.equals(obj);
    }

    Runnable getPoller(AbstractProject p, Cause cause, List<Action> actions) {
        return new PollRunner(p, cause, actions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PollRunner
    implements Runnable {
        private final AbstractProject project;
        private final Cause cause;
        private final List<Action> buildActions;
        private final TaskListener taskListener;

        public PollRunner(AbstractProject p, Cause cause, List<Action> actions) {
            this.project = p;
            this.cause = cause;
            this.buildActions = actions;
            LogTaskListener tl = new LogTaskListener(LOGGER, Level.INFO);
            this.taskListener = tl instanceof Serializable ? tl : new StreamTaskListener(System.out);
        }

        @Override
        public void run() {
            LOGGER.info("Polling for SCM changes in " + this.project.getName());
            if (this.project.pollSCMChanges(this.taskListener)) {
                LOGGER.info("SCM changes found for " + this.project.getName() + ". Triggering build.");
                if (this.project.scheduleBuild(this.project.getQuietPeriod(), this.cause, this.buildActions.toArray(new Action[this.buildActions.size()]))) {
                    LOGGER.info("Build of " + this.project.getName() + " scheduled successfully.");
                } else {
                    LOGGER.info("No build of " + this.project.getName() + " scheduled - this usually means that another build is already in the queue.");
                }
            } else {
                LOGGER.info(Messages.DownstreamTrigger_NoSCMChanges(this.project.getName()));
            }
        }
    }
}

