/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.downstream_ext;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.listeners.ItemListener;
import hudson.plugins.downstream_ext.DownstreamDependency;
import hudson.plugins.downstream_ext.MatrixTrigger;
import hudson.plugins.downstream_ext.Messages;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamTrigger
extends Notifier
implements DependecyDeclarer,
MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(DownstreamTrigger.class.getName());
    private String childProjects;
    private Result threshold = Result.SUCCESS;
    private Strategy thresholdStrategy;
    private final boolean onlyIfSCMChanges;
    @Deprecated
    private transient Boolean triggerOnlyOnceWhenMatrixEnds;
    private MatrixTrigger matrixTrigger;
    private static final ConcurrentHashMap<AbstractProject<?, ?>, Executor> executors = new ConcurrentHashMap();

    @DataBoundConstructor
    public DownstreamTrigger(String childProjects, String threshold, boolean onlyIfSCMChanges, String strategy, String matrixTrigger) {
        this(childProjects, DownstreamTrigger.resultFromString(threshold), onlyIfSCMChanges, Strategy.valueOf(strategy), matrixTrigger != null ? MatrixTrigger.valueOf(matrixTrigger) : null);
    }

    public DownstreamTrigger(String childProjects, Result threshold, boolean onlyIfSCMChanges, Strategy strategy, MatrixTrigger matrixTrigger) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
        this.onlyIfSCMChanges = onlyIfSCMChanges;
        this.thresholdStrategy = strategy;
        this.matrixTrigger = matrixTrigger;
    }

    private static Result resultFromString(String s) {
        Result result = Result.fromString((String)s);
        if (!result.toString().equals(s)) {
            throw new IllegalArgumentException("Unknown result type '" + s + "'");
        }
        return result;
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    public boolean isOnlyIfSCMChanges() {
        return this.onlyIfSCMChanges;
    }

    public MatrixTrigger getMatrixTrigger() {
        return this.matrixTrigger;
    }

    public List<AbstractProject> getChildProjects() {
        return Items.fromNameList((String)this.childProjects, AbstractProject.class);
    }

    public Strategy getStrategy() {
        return this.thresholdStrategy;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (AbstractProject downstream : this.getChildProjects()) {
            graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency(owner, downstream, this));
        }
        if (this.matrixTrigger != null && (this.matrixTrigger == MatrixTrigger.ONLY_CONFIGURATIONS || this.matrixTrigger == MatrixTrigger.BOTH) && owner instanceof MatrixProject) {
            MatrixProject proj = (MatrixProject)owner;
            Collection activeConfigurations = proj.getActiveConfigurations();
            for (MatrixConfiguration conf : activeConfigurations) {
                for (AbstractProject downstream : this.getChildProjects()) {
                    graph.addDependency((DependencyGraph.Dependency)new DownstreamDependency((AbstractProject<?, ?>)conf, (AbstractProject<?, ?>)downstream, this));
                }
            }
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        String[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder b = new StringBuilder();
            for (String p : projects) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(p);
            }
            this.childProjects = b.toString();
        }
        return changed;
    }

    public static void executeForProject(AbstractProject<?, ?> project, Runnable run) {
        Executor old;
        Executor executor = executors.get(project);
        if (executor == null && (old = executors.putIfAbsent(project, executor = Executors.newSingleThreadExecutor())) != null) {
            executor = old;
        }
        executor.execute(run);
    }

    private Object readResolve() {
        if (this.thresholdStrategy == null) {
            this.thresholdStrategy = Strategy.AND_HIGHER;
        }
        if (this.triggerOnlyOnceWhenMatrixEnds != null) {
            this.matrixTrigger = this.triggerOnlyOnceWhenMatrixEnds != false ? MatrixTrigger.ONLY_PARENT : MatrixTrigger.ONLY_CONFIGURATIONS;
        }
        return this;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                if (DownstreamTrigger.this.matrixTrigger != null && (DownstreamTrigger.this.matrixTrigger == MatrixTrigger.ONLY_PARENT || DownstreamTrigger.this.matrixTrigger == MatrixTrigger.BOTH)) {
                    return BuildTrigger.execute((AbstractBuild)this.build, (BuildListener)this.listener);
                }
                return true;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        AND_HIGHER("equal or over"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.isBetterOrEqualTo(threshold);
            }
        }
        ,
        EXACT("equal"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.equals(threshold);
            }
        }
        ,
        AND_LOWER("equal or under"){

            public boolean evaluate(Result threshold, Result actualResult) {
                return actualResult.isWorseOrEqualTo(threshold);
            }
        };

        public final String displayName;

        private Strategy(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract boolean evaluate(Result var1, Result var2);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTrigger.DescriptorImpl {
        public static final String[] THRESHOLD_VALUES = new String[]{Result.SUCCESS.toString(), Result.UNSTABLE.toString(), Result.FAILURE.toString(), Result.ABORTED.toString()};
        public static final String[] MATRIX_TRIGGER_VALUES;
        public static final Strategy[] STRATEGY_VALUES;

        public String getDisplayName() {
            return Messages.DownstreamTrigger_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/downstream-ext/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String matrixTrigger = formData.has("matrixTrigger") ? formData.getString("matrixTrigger") : null;
            return new DownstreamTrigger(formData.getString("childProjects"), formData.getString("threshold"), formData.has("onlyIfSCMChanges") && formData.getBoolean("onlyIfSCMChanges"), formData.getString("strategy"), matrixTrigger);
        }

        public boolean isMatrixProject(AbstractProject project) {
            return project instanceof MatrixProject;
        }

        static {
            MatrixTrigger[] values = MatrixTrigger.values();
            MATRIX_TRIGGER_VALUES = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                DescriptorImpl.MATRIX_TRIGGER_VALUES[i] = values[i].toString();
            }
            STRATEGY_VALUES = Strategy.values();
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    DownstreamTrigger t = (DownstreamTrigger)p.getPublishersList().get(DownstreamTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }

            public void onDeleted(Item item) {
                executors.remove(item);
            }
        }
    }
}

