/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.doxygen.DoxygenArchiver;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DoxygenArchiver
extends Publisher {
    private final String doxyfilePath;
    private final boolean keepAll;
    public static final Descriptor<Publisher> DESCRIPTOR = new DoxygenArchiverDescriptor();
    private static final String DOXYGEN_KEY_OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    private static final String DOXYGEN_KEY_GENERATE_HTML = "GENERATE_HTML";
    private static final String DOXYGEN_KEY_HTML_OUTPUT = "HTML_OUTPUT";
    private static final String DOXYGEN_VALUE_YES = "YES";
    private Map<String, String> doxyfileInfos = new HashMap();

    public String getDoxyfilePath() {
        return this.doxyfilePath;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    private DoxygenArchiver(String doxyfilePath, boolean keepAll) {
        this.doxyfilePath = doxyfilePath.trim();
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private void loadDoxyFile(FilePath doxyfilePath) throws FileNotFoundException, IOException, InterruptedException {
        String line;
        String separator = "=";
        FileInputStream ips = new FileInputStream(new File(doxyfilePath.toURI()));
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((line = br.readLine()) != null) {
            if (line.indexOf("=") == -1) continue;
            String[] elements = line.split("=");
            this.doxyfileInfos.put(elements[0].trim(), elements[1].trim());
        }
        br.close();
        ipsr.close();
        ((InputStream)ips).close();
    }

    private boolean isDoxygenGenerateHtml() {
        String valGenerateHtml = (String)this.doxyfileInfos.get("GENERATE_HTML");
        if (valGenerateHtml != null) {
            return valGenerateHtml.equalsIgnoreCase("YES");
        }
        return false;
    }

    private FilePath getDoxygenGeneratedDir(AbstractBuild<?, ?> build) {
        String outputHTML = (String)this.doxyfileInfos.get("HTML_OUTPUT");
        String outputDirectory = (String)this.doxyfileInfos.get("OUTPUT_DIRECTORY");
        String doxyGenDir = null;
        if (outputDirectory != null && outputDirectory.trim().length() != 0) {
            doxyGenDir = outputDirectory;
        }
        if (outputHTML != null && outputHTML.trim().length() != 0) {
            doxyGenDir = doxyGenDir != null ? doxyGenDir + File.separator + outputHTML : outputHTML;
            return ((AbstractProject)build.getParent()).getModuleRoot().child(doxyGenDir);
        }
        return null;
    }

    private static File getDoxygenDir(AbstractItem project) {
        return new File(project.getRootDir(), "doxygen/html");
    }

    private static File getDoxygenDir(Run run) {
        return new File(run.getRootDir(), "doxygen/html");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.loadDoxyFile(((AbstractProject)build.getParent()).getWorkspace().child(this.doxyfilePath));
        if (this.isDoxygenGenerateHtml()) {
            FilePath doxygenGenerateDir = this.getDoxygenGeneratedDir(build);
            FilePath target = new FilePath(this.keepAll ? DoxygenArchiver.getDoxygenDir(build) : DoxygenArchiver.getDoxygenDir((AbstractItem)build.getProject()));
            try {
                if (doxygenGenerateDir.copyRecursiveTo("**/*", target) == 0) {
                    if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                        // empty if block
                    }
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("error"));
                build.setResult(Result.FAILURE);
                return true;
            }
            if (this.keepAll) {
                build.addAction((Action)new DoxygenBuildAction(build));
            }
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new DoxygenAction((AbstractItem)project);
    }

    static /* synthetic */ File access$100(Run x0) {
        return DoxygenArchiver.getDoxygenDir((Run)x0);
    }

    static /* synthetic */ File access$200(AbstractItem x0) {
        return DoxygenArchiver.getDoxygenDir((AbstractItem)x0);
    }
}

