/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenArchiver
extends Publisher {
    private final String doxyfilePath;
    private final boolean keepAll;
    public static final Descriptor<Publisher> DESCRIPTOR = new DoxygenArchiverDescriptor();
    private static final String DOXYGEN_KEY_OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    private static final String DOXYGEN_KEY_GENERATE_HTML = "GENERATE_HTML";
    private static final String DOXYGEN_KEY_HTML_OUTPUT = "HTML_OUTPUT";
    private static final String DOXYGEN_VALUE_YES = "YES";
    private Map<String, String> doxyfileInfos = new HashMap<String, String>();

    public String getDoxyfilePath() {
        return this.doxyfilePath;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    private DoxygenArchiver(String doxyfilePath, boolean keepAll) {
        this.doxyfilePath = doxyfilePath.trim();
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private void loadDoxyFile(FilePath doxyfilePath) throws FileNotFoundException, IOException, InterruptedException {
        String line;
        String separator = "=";
        FileInputStream ips = new FileInputStream(new File(doxyfilePath.toURI()));
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((line = br.readLine()) != null) {
            if (line.indexOf("=") == -1) continue;
            String[] elements = line.split("=");
            this.doxyfileInfos.put(elements[0].trim(), elements[1].trim());
        }
        br.close();
        ipsr.close();
        ((InputStream)ips).close();
    }

    private boolean isDoxygenGenerateHtml() {
        String valGenerateHtml = this.doxyfileInfos.get(DOXYGEN_KEY_GENERATE_HTML);
        if (valGenerateHtml != null) {
            return valGenerateHtml.equalsIgnoreCase(DOXYGEN_VALUE_YES);
        }
        return false;
    }

    private FilePath getDoxygenGeneratedDir(AbstractBuild<?, ?> build) {
        String outputHTML = this.doxyfileInfos.get(DOXYGEN_KEY_HTML_OUTPUT);
        String outputDirectory = this.doxyfileInfos.get(DOXYGEN_KEY_OUTPUT_DIRECTORY);
        String doxyGenDir = null;
        if (outputDirectory != null && outputDirectory.trim().length() != 0) {
            doxyGenDir = outputDirectory;
        }
        if (outputHTML != null && outputHTML.trim().length() != 0) {
            doxyGenDir = doxyGenDir != null ? doxyGenDir + File.separator + outputHTML : outputHTML;
            return ((AbstractProject)build.getParent()).getModuleRoot().child(doxyGenDir);
        }
        return null;
    }

    private static File getDoxygenDir(AbstractItem project) {
        return new File(project.getRootDir(), "doxygen/html");
    }

    private static File getDoxygenDir(Run run) {
        return new File(run.getRootDir(), "doxygen/html");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.loadDoxyFile(((AbstractProject)build.getParent()).getWorkspace().child(this.doxyfilePath));
        if (this.isDoxygenGenerateHtml()) {
            FilePath doxygenGenerateDir = this.getDoxygenGeneratedDir(build);
            FilePath target = new FilePath(this.keepAll ? DoxygenArchiver.getDoxygenDir(build) : DoxygenArchiver.getDoxygenDir((AbstractItem)build.getProject()));
            try {
                if (doxygenGenerateDir.copyRecursiveTo("**/*", target) == 0) {
                    if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                        // empty if block
                    }
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("error"));
                build.setResult(Result.FAILURE);
                return true;
            }
            if (this.keepAll) {
                build.addAction((Action)new DoxygenBuildAction(build));
            }
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new DoxygenAction((AbstractItem)project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoxygenBuildAction
    extends BaseDoxygenAction {
        private final AbstractBuild<?, ?> build;

        public DoxygenBuildAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " doxygen/html";
        }

        @Override
        protected File dir() {
            return new File(this.build.getRootDir(), "doxygen/html");
        }
    }

    public static class DoxygenAction
    extends BaseDoxygenAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public DoxygenAction(AbstractItem project) {
            this.project = project;
        }

        protected File dir() {
            File doxygenDir;
            AbstractProject abstractProject;
            Run run;
            if (this.project instanceof AbstractProject && (run = (abstractProject = (AbstractProject)this.project).getLastSuccessfulBuild()) != null && (doxygenDir = DoxygenArchiver.getDoxygenDir(run)).exists()) {
                return doxygenDir;
            }
            return DoxygenArchiver.getDoxygenDir(this.project);
        }

        protected String getTitle() {
            return this.project.getDisplayName() + " doxygen";
        }
    }

    protected static abstract class BaseDoxygenAction
    implements Action {
        protected BaseDoxygenAction() {
        }

        public String getUrlName() {
            return "doxygen";
        }

        public String getDisplayName() {
            return "DoxyGen HTML";
        }

        public String getIconFileName() {
            if (this.dir().exists()) {
                return "help.gif";
            }
            return null;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            new DirectoryBrowserSupport((ModelObject)this, this.getTitle()).serveFile(req, rsp, new FilePath(this.dir()), "help.gif", false);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoxygenArchiverDescriptor
    extends BuildStepDescriptor<Publisher> {
        public DoxygenArchiverDescriptor() {
            super(DoxygenArchiver.class);
        }

        public String getDisplayName() {
            return "Publish Doxygen";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            DoxygenArchiver p = new DoxygenArchiver(req.getParameter("doxygen.doxyfilePath"), req.getParameter("doxygen.keepall") != null);
            return p;
        }

        public String getHelpFile() {
            return "/plugin/doxygen/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return !AbstractMavenProject.class.isAssignableFrom(jobType);
        }
    }
}

