/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenDirectoryParser
implements FilePath.FileCallable<FilePath>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, String> doxyfileInfos = new HashMap<String, String>();
    private static final String DOXYGEN_KEY_OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    private static final String DOXYGEN_KEY_GENERATE_HTML = "GENERATE_HTML";
    private static final String DOXYGEN_KEY_HTML_OUTPUT = "HTML_OUTPUT";
    private static final String DOXYGEN_DEFAULT_HTML_OUTPUT = "html";
    private static final String DOXYGEN_VALUE_YES = "YES";
    private PrintStream logger;
    private String publishType;
    private String doxygenHtmlDirectory;
    private String doxyfilePath;

    public DoxygenDirectoryParser(PrintStream logger, String publishType, String doxyfilePath, String doxygenHtmlDirectory) {
        this.logger = logger;
        this.publishType = publishType;
        this.doxyfilePath = doxyfilePath;
        this.doxygenHtmlDirectory = doxygenHtmlDirectory;
    }

    public FilePath invoke(File workspace, VirtualChannel channel) throws IOException {
        try {
            return "HtmlDirectory".equals(this.publishType) ? this.retrieveDoxygenDirectoryFromHudsonConfiguration(this.doxygenHtmlDirectory, new FilePath(workspace), this.logger) : this.retrieveDoxygenDirectoryFromDoxyfile(this.doxyfilePath, new FilePath(workspace), this.logger);
        }
        catch (InterruptedException ie) {
            throw new AbortException(ie.getMessage());
        }
    }

    private boolean isDoxygenGenerateHtml() {
        if (this.doxyfileInfos == null) {
            return false;
        }
        String generatedHtmlKeyVal = this.doxyfileInfos.get(DOXYGEN_KEY_GENERATE_HTML);
        if (generatedHtmlKeyVal == null) {
            return true;
        }
        return DOXYGEN_VALUE_YES.equalsIgnoreCase(generatedHtmlKeyVal);
    }

    private FilePath retrieveDoxygenDirectoryFromHudsonConfiguration(String doxygenHtmlDirectory, FilePath base, PrintStream logger) throws InterruptedException, IOException {
        FilePath doxygenGeneratedDir = null;
        logger.println("Using the Doxygen HTML directory specified by the configuration.");
        if (doxygenHtmlDirectory == null) {
            throw new IllegalArgumentException("Error on the given doxygen html directory.");
        }
        if (doxygenHtmlDirectory.trim().length() == 0) {
            throw new IllegalArgumentException("Error on the given doxygen html directory.");
        }
        doxygenGeneratedDir = new FilePath(base, doxygenHtmlDirectory);
        if (!doxygenGeneratedDir.exists()) {
            throw new AbortException("The directory '" + doxygenGeneratedDir + "' doesn't exist.");
        }
        return doxygenGeneratedDir;
    }

    private FilePath getDoxygenGeneratedDir(FilePath base, PrintStream logger) {
        String outputHTML;
        if (this.doxyfileInfos == null) {
            return null;
        }
        String outputDirectory = this.doxyfileInfos.get(DOXYGEN_KEY_OUTPUT_DIRECTORY);
        String doxyGenDir = null;
        if (outputDirectory != null && outputDirectory.trim().length() != 0) {
            doxyGenDir = outputDirectory;
        }
        if ((outputHTML = this.doxyfileInfos.get(DOXYGEN_KEY_HTML_OUTPUT)) != null && outputHTML.trim().length() != 0) {
            doxyGenDir = doxyGenDir != null ? doxyGenDir + File.separator + outputHTML : outputHTML;
            return new FilePath(base, doxyGenDir);
        }
        outputHTML = DOXYGEN_DEFAULT_HTML_OUTPUT;
        logger.println("The HTML_OUTPUT tag is not present or is left blank.html will be used as the default path.");
        return null;
    }

    private void loadDoxyFile(FilePath doxyfilePath, PrintStream logger) throws FileNotFoundException, IOException, InterruptedException {
        logger.println("The Doxyfile path is '" + doxyfilePath.toURI() + "'.");
        String separator = "=";
        FileInputStream ips = new FileInputStream(new File(doxyfilePath.toURI()));
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        String line = null;
        if (this.doxyfileInfos == null) {
            this.doxyfileInfos = new HashMap<String, String>();
        }
        while ((line = br.readLine()) != null) {
            if (line.indexOf("=") == -1) continue;
            String[] elements = line.split("=");
            this.doxyfileInfos.put(elements[0].trim(), elements[1].trim());
        }
        br.close();
        ipsr.close();
        ((InputStream)ips).close();
    }

    private FilePath retrieveDoxygenDirectoryFromDoxyfile(String doxyfilePath, FilePath base, PrintStream logger) throws FileNotFoundException, IOException, InterruptedException {
        FilePath doxygenGeneratedDir;
        logger.println("Using the Doxyfile information.");
        this.loadDoxyFile(base.child(doxyfilePath), logger);
        if (this.isDoxygenGenerateHtml()) {
            doxygenGeneratedDir = this.getDoxygenGeneratedDir(base, logger);
            if (!doxygenGeneratedDir.exists()) {
                throw new AbortException("The directory '" + doxygenGeneratedDir + "' doesn't exist.");
            }
        } else {
            throw new AbortException("The tag GENERATE_HTML is not set to 'YES'. The Doxygen plugin publishes only HTML documentations.");
        }
        return doxygenGeneratedDir;
    }
}

