/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.doxygen.DoxygenDirectoryParser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenArchiver
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DoxygenArchiverDescriptor DESCRIPTOR = new DoxygenArchiverDescriptor();
    private final String doxyfilePath;
    private final boolean keepAll;
    private final String publishType;
    private final String doxygenHtmlDirectory;

    public String getDoxyfilePath() {
        return this.doxyfilePath;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public String getPublishType() {
        return this.publishType;
    }

    public String getDoxygenHtmlDirectory() {
        return this.doxygenHtmlDirectory;
    }

    @DataBoundConstructor
    public DoxygenArchiver(String publishType, String doxyfilePath, String doxygenHtmlDirectory, boolean keepAll) {
        this.publishType = publishType;
        this.doxyfilePath = doxyfilePath.trim();
        this.doxygenHtmlDirectory = doxygenHtmlDirectory;
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private static File getDoxygenDir(AbstractItem project) {
        return new File(project.getRootDir(), "doxygen/html");
    }

    private static File getDoxygenDir(Run run) {
        return new File(run.getRootDir(), "doxygen/html");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Publishing Doxygen HTML results.");
        try {
            DoxygenDirectoryParser parser = new DoxygenDirectoryParser(this.publishType, this.doxyfilePath, this.doxygenHtmlDirectory);
            FilePath doxygenGeneratedDir = (FilePath)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
            listener.getLogger().println("The determined Doxygen directory is '" + doxygenGeneratedDir + "'.");
            FilePath target = new FilePath(this.keepAll ? DoxygenArchiver.getDoxygenDir(build) : DoxygenArchiver.getDoxygenDir((AbstractItem)build.getProject()));
            if (doxygenGeneratedDir.copyRecursiveTo("**/*", target) == 0) {
                if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    // empty if block
                }
                listener.getLogger().println("Failure to copy the generated doxygen html documentation at '" + this.doxygenHtmlDirectory + "' to '" + target + "'");
                build.setResult(Result.FAILURE);
                return true;
            }
            if (this.keepAll) {
                build.addAction((Action)new DoxygenBuildAction(build));
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return true;
        }
        listener.getLogger().println("End publishing Doxygen HTML results.");
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new DoxygenAction((AbstractItem)project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoxygenBuildAction
    extends BaseDoxygenAction {
        private final AbstractBuild<?, ?> build;

        public DoxygenBuildAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " doxygen/html";
        }

        @Override
        protected File dir() {
            return new File(this.build.getRootDir(), "doxygen/html");
        }
    }

    public static class DoxygenAction
    extends BaseDoxygenAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public DoxygenAction(AbstractItem project) {
            this.project = project;
        }

        protected File dir() {
            File doxygenDir;
            AbstractProject abstractProject;
            Run run;
            if (this.project instanceof AbstractProject && (run = (abstractProject = (AbstractProject)this.project).getLastSuccessfulBuild()) != null && (doxygenDir = DoxygenArchiver.getDoxygenDir(run)).exists()) {
                return doxygenDir;
            }
            return DoxygenArchiver.getDoxygenDir(this.project);
        }

        protected String getTitle() {
            return this.project.getDisplayName() + " doxygen";
        }
    }

    protected static abstract class BaseDoxygenAction
    implements Action {
        protected BaseDoxygenAction() {
        }

        public String getUrlName() {
            return "doxygen";
        }

        public String getDisplayName() {
            return "DoxyGen HTML";
        }

        public String getIconFileName() {
            if (this.dir().exists()) {
                return "help.gif";
            }
            return null;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            new DirectoryBrowserSupport((ModelObject)this, this.getTitle()).serveFile(req, rsp, new FilePath(this.dir()), "help.gif", false);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoxygenArchiverDescriptor
    extends BuildStepDescriptor<Publisher> {
        public static final String DOXYGEN_DOXYFILE_PUBLISHTYPE = "DoxyFile";
        public static final String DOXYGEN_HTMLDIRECTORY_PUBLISHTYPE = "HtmlDirectory";
        public static final String DEFAULT_DOXYGEN_PUBLISHTYPE = "DoxyFile";

        public DoxygenArchiverDescriptor() {
            super(DoxygenArchiver.class);
        }

        public String getDisplayName() {
            return "Publish Doxygen";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            DoxygenArchiver p = new DoxygenArchiver(req.getParameter("doxygen.publishType"), req.getParameter("doxygen.doxyfilePath"), req.getParameter("doxygen.doxygenHtmlDirectory"), req.getParameter("doxygen.keepall") != null);
            return p;
        }

        public String getHelpFile() {
            return "/plugin/doxygen/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

