/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.doxygen.DoxygenArchiver;
import hudson.plugins.doxygen.DoxygenDirectoryParser;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DoxygenArchiver
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DoxygenArchiverDescriptor DESCRIPTOR = new DoxygenArchiverDescriptor();
    private final String doxyfilePath;
    private final boolean keepAll;
    private final String publishType;
    private final String doxygenHtmlDirectory;

    public String getDoxyfilePath() {
        return this.doxyfilePath;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public String getPublishType() {
        return this.publishType;
    }

    public String getDoxygenHtmlDirectory() {
        return this.doxygenHtmlDirectory;
    }

    @DataBoundConstructor
    public DoxygenArchiver(String publishType, String doxyfilePath, String doxygenHtmlDirectory, boolean keepAll) {
        this.publishType = publishType;
        this.doxyfilePath = doxyfilePath.trim();
        this.doxygenHtmlDirectory = doxygenHtmlDirectory;
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private static File getDoxygenDir(AbstractItem project) {
        return new File(project.getRootDir(), "doxygen/html");
    }

    private static File getDoxygenDir(Run run) {
        return new File(run.getRootDir(), "doxygen/html");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            listener.getLogger().println("Publishing Doxygen HTML results.");
            try {
                DoxygenDirectoryParser parser = new DoxygenDirectoryParser(this.publishType, this.doxyfilePath, this.doxygenHtmlDirectory);
                FilePath doxygenGeneratedDir = (FilePath)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
                listener.getLogger().println("The determined Doxygen directory is '" + doxygenGeneratedDir + "'.");
                FilePath target = new FilePath(this.keepAll ? DoxygenArchiver.getDoxygenDir(build) : DoxygenArchiver.getDoxygenDir((AbstractItem)build.getProject()));
                if (doxygenGeneratedDir.copyRecursiveTo("**/*", target) == 0) {
                    if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                        // empty if block
                    }
                    listener.getLogger().println("Failure to copy the generated doxygen html documentation at '" + this.doxygenHtmlDirectory + "' to '" + target + "'");
                    build.setResult(Result.FAILURE);
                    return true;
                }
                if (this.keepAll) {
                    build.addAction((Action)new DoxygenBuildAction(build));
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError("error"));
                build.setResult(Result.FAILURE);
                return true;
            }
            listener.getLogger().println("End publishing Doxygen HTML results.");
        } else {
            listener.getLogger().println("Build failed. Publishing Doxygen skipped.");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new DoxygenAction((AbstractItem)project);
    }

    static /* synthetic */ File access$000(Run x0) {
        return DoxygenArchiver.getDoxygenDir((Run)x0);
    }

    static /* synthetic */ File access$100(AbstractItem x0) {
        return DoxygenArchiver.getDoxygenDir((AbstractItem)x0);
    }
}

