/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.doxygen;

import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenDirectoryParser
implements FilePath.FileCallable<FilePath>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern DRIVE_PATTERN = Pattern.compile("[A-Za-z]:\\\\.+");
    private static final Logger LOGGER = Logger.getLogger(DoxygenDirectoryParser.class.getName());
    private transient Map<String, String> doxyfileInfos = new HashMap<String, String>();
    private static final String DOXYGEN_KEY_OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    private static final String DOXYGEN_KEY_GENERATE_HTML = "GENERATE_HTML";
    private static final String DOXYGEN_KEY_HTML_OUTPUT = "HTML_OUTPUT";
    private static final String DOXYGEN_DEFAULT_HTML_OUTPUT = "html";
    private static final String DOXYGEN_VALUE_YES = "YES";
    private String publishType;
    private String doxygenHtmlDirectory;
    private String doxyfilePath;

    public DoxygenDirectoryParser(String publishType, String doxyfilePath, String doxygenHtmlDirectory) {
        this.publishType = publishType;
        this.doxyfilePath = doxyfilePath;
        this.doxygenHtmlDirectory = doxygenHtmlDirectory;
    }

    public FilePath invoke(File workspace, VirtualChannel channel) throws IOException {
        try {
            return "HtmlDirectory".equals(this.publishType) ? this.retrieveDoxygenDirectoryFromHudsonConfiguration(this.doxygenHtmlDirectory, new FilePath(workspace)) : this.retrieveDoxygenDirectoryFromDoxyfile(this.doxyfilePath, new FilePath(workspace));
        }
        catch (InterruptedException ie) {
            throw new AbortException(ie.getMessage());
        }
    }

    private boolean isDoxygenGenerateHtml() {
        if (this.doxyfileInfos == null) {
            return false;
        }
        String generatedHtmlKeyVal = this.doxyfileInfos.get(DOXYGEN_KEY_GENERATE_HTML);
        if (generatedHtmlKeyVal == null) {
            return true;
        }
        return DOXYGEN_VALUE_YES.equalsIgnoreCase(generatedHtmlKeyVal);
    }

    private FilePath retrieveDoxygenDirectoryFromHudsonConfiguration(String doxygenHtmlDirectory, FilePath base) throws InterruptedException, IOException {
        FilePath doxygenGeneratedDir = null;
        LOGGER.log(Level.INFO, "Using the Doxygen HTML directory specified by the configuration.");
        if (doxygenHtmlDirectory == null) {
            throw new IllegalArgumentException("Error on the given doxygen html directory.");
        }
        if (doxygenHtmlDirectory.trim().length() == 0) {
            throw new IllegalArgumentException("Error on the given doxygen html directory.");
        }
        doxygenGeneratedDir = new FilePath(base, doxygenHtmlDirectory);
        if (!doxygenGeneratedDir.exists()) {
            throw new AbortException("The directory '" + doxygenGeneratedDir + "' doesn't exist.");
        }
        return doxygenGeneratedDir;
    }

    private FilePath getDoxygenGeneratedDir(FilePath base) {
        String outputHTML;
        if (this.doxyfileInfos == null) {
            return null;
        }
        String outputDirectory = this.doxyfileInfos.get(DOXYGEN_KEY_OUTPUT_DIRECTORY);
        String doxyGenDir = null;
        if (outputDirectory != null && outputDirectory.trim().length() != 0) {
            doxyGenDir = outputDirectory;
        }
        if ((outputHTML = this.doxyfileInfos.get(DOXYGEN_KEY_HTML_OUTPUT)) != null && outputHTML.trim().length() != 0) {
            doxyGenDir = doxyGenDir != null ? doxyGenDir + File.separator + outputHTML : outputHTML;
            return new FilePath(base, doxyGenDir);
        }
        outputHTML = DOXYGEN_DEFAULT_HTML_OUTPUT;
        LOGGER.log(Level.INFO, "The HTML_OUTPUT tag is not present or is left blank.html will be used as the default path.");
        return null;
    }

    private void loadDoxyFile(FilePath doxyfilePath) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "The Doxyfile path is '" + doxyfilePath.toURI() + "'.");
        String separator = "=";
        FileInputStream ips = new FileInputStream(new File(doxyfilePath.toURI()));
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        String line = null;
        ArrayList<String> doxyfileDirectories = new ArrayList<String>();
        if (this.doxyfileInfos == null) {
            this.doxyfileInfos = new HashMap<String, String>();
        }
        while ((line = br.readLine()) != null) {
            String[] elements;
            if (this.doxyfileLineIsAComment(line) || (elements = line.split("=")).length == 1) continue;
            if (elements[0].startsWith("@INCLUDE_PATH")) {
                Collections.addAll(doxyfileDirectories, elements[1].split(" "));
                continue;
            }
            if (elements[0].startsWith("@INCLUDE")) {
                this.processIncludeFile(doxyfileDirectories, doxyfilePath.getParent(), elements[1].trim());
                continue;
            }
            this.doxyfileInfos.put(elements[0].trim(), elements[1].trim());
        }
        br.close();
        ipsr.close();
        ((InputStream)ips).close();
    }

    private boolean doxyfileLineIsAComment(String line) {
        return line.trim().startsWith("#");
    }

    private static boolean isAbsolute(String rel) {
        return rel.startsWith("/") || DRIVE_PATTERN.matcher(rel).matches();
    }

    private void processIncludeFileWithNoIncludedDirectories(FilePath parentFile, String includedFile) throws IOException, InterruptedException {
        FilePath includedFilePath;
        FilePath filePath = includedFilePath = DoxygenDirectoryParser.isAbsolute(includedFile) ? new FilePath(new File(includedFile)) : new FilePath(parentFile, includedFile);
        if (!includedFilePath.exists()) {
            throw new AbortException("Doxyfile is incorrect. Included file '" + includedFile + "' doesn't exist.");
        }
        this.loadDoxyFile(includedFilePath);
    }

    private void processIncludeFileWithIncludedDirectories(List<String> doxyfileDirectories, FilePath parentFile, String includedFile) throws IOException, InterruptedException {
        FilePath includedFilePath = null;
        boolean findIncludedFileInDirectories = false;
        if (DoxygenDirectoryParser.isAbsolute(includedFile)) {
            this.loadDoxyFile(new FilePath(new File(includedFile)));
            return;
        }
        includedFilePath = new FilePath(parentFile, includedFile);
        if (includedFilePath.exists()) {
            this.loadDoxyFile(includedFilePath);
            return;
        }
        for (String doxyfileDirectory : doxyfileDirectories) {
            FilePath directoryFilePath = DoxygenDirectoryParser.isAbsolute(doxyfileDirectory) ? new FilePath(new File(doxyfileDirectory)) : new FilePath(parentFile, doxyfileDirectory);
            if (!directoryFilePath.exists() || !(includedFilePath = new FilePath(directoryFilePath, includedFile)).exists()) continue;
            this.loadDoxyFile(includedFilePath);
            findIncludedFileInDirectories = true;
            break;
        }
        if (!findIncludedFileInDirectories) {
            throw new AbortException("Doxyfile is incorrect. Included file '" + includedFile + "' doesn't exist.");
        }
    }

    private void processIncludeFile(List<String> doxyfileDirectories, FilePath parentFile, String includedFile) throws IOException, InterruptedException {
        if (doxyfileDirectories == null || doxyfileDirectories.isEmpty()) {
            this.processIncludeFileWithNoIncludedDirectories(parentFile, includedFile);
        } else {
            this.processIncludeFileWithIncludedDirectories(doxyfileDirectories, parentFile, includedFile);
        }
    }

    private FilePath retrieveDoxygenDirectoryFromDoxyfile(String doxyfilePath, FilePath base) throws IOException, InterruptedException {
        FilePath doxygenGeneratedDir;
        LOGGER.log(Level.INFO, "Using the Doxyfile information.");
        this.loadDoxyFile(base.child(doxyfilePath));
        if (this.isDoxygenGenerateHtml()) {
            doxygenGeneratedDir = this.getDoxygenGeneratedDir(base);
            if (!doxygenGeneratedDir.exists()) {
                throw new AbortException("The directory '" + doxygenGeneratedDir + "' doesn't exist.");
            }
        } else {
            throw new AbortException("The tag GENERATE_HTML is not set to 'YES'. The Doxygen plugin publishes only HTML documentations.");
        }
        return doxygenGeneratedDir;
    }
}

