/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.jndi.BitronixInitialContextFactory;
import hudson.drools.DBSettings;
import hudson.drools.DriverDBSettings;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevelopmentDBSettings
extends DriverDBSettings {
    private transient BitronixTransactionManager transactionManager;

    @DataBoundConstructor
    public DevelopmentDBSettings(String className, String user, String password, String url, String hibernateDialect) {
        super(className, user, password, url, hibernateDialect);
    }

    public void start() throws NamingException {
        System.setProperty("java.naming.factory.initial", BitronixInitialContextFactory.class.getName());
        super.start();
        this.transactionManager = TransactionManagerServices.getTransactionManager();
        try {
            new InitialContext().bind("java:comp/UserTransaction", (Object)this.transactionManager);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        super.stop();
        this.transactionManager.shutdown();
    }

    public BitronixTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(BitronixTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Descriptor<DBSettings> getDescriptor() {
        return Hudson.getInstance().getDescriptor(DevelopmentDBSettings.class);
    }
}

