/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import hudson.drools.DBSettings;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.hibernate.transaction.BTMTransactionManagerLookup;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDBSettings
extends DBSettings {
    private transient PoolingDataSource dataSource;
    private final String className;
    private final int maxPoolSize;
    private final String user;
    private final String password;
    private final String url;
    private final String hibernateDialect;

    @DataBoundConstructor
    public DriverDBSettings(String className, String user, String password, String url, String hibernateDialect) {
        this.className = className;
        this.maxPoolSize = 20;
        this.user = user;
        this.password = password;
        this.url = url;
        this.hibernateDialect = hibernateDialect;
    }

    public void start() throws NamingException {
        InitialContext initialContext = new InitialContext();
        try {
            initialContext.unbind(this.getDataSourceName());
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            initialContext.unbind("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            initialContext.createSubcontext("jdbc");
        }
        catch (NamingException e2) {
            // empty catch block
        }
        try {
            initialContext.createSubcontext("java:comp");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.dataSource = new PoolingDataSource();
        this.dataSource.setUniqueName(this.getDataSourceName());
        this.dataSource.setClassName(this.className);
        this.dataSource.setMaxPoolSize(this.maxPoolSize);
        this.dataSource.setAllowLocalTransactions(true);
        this.dataSource.getDriverProperties().put("user", this.user);
        this.dataSource.getDriverProperties().put("password", this.password);
        this.dataSource.getDriverProperties().put("URL", this.url);
        this.dataSource.init();
        initialContext.bind(this.getDataSourceName(), (Object)this.dataSource);
        initialContext.bind("java:comp/UserTransaction", (Object)TransactionManagerServices.getTransactionManager());
    }

    public void stop() {
        TransactionManagerServices.getTransactionManager().shutdown();
        this.dataSource.close();
    }

    public PoolingDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(PoolingDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getClassName() {
        return this.className;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDataSourceName() {
        return "jdbc/processInstanceDS";
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public Descriptor<DBSettings> getDescriptor() {
        return Hudson.getInstance().getDescriptor(DriverDBSettings.class);
    }

    public String getTransactionManagerLookupClass() {
        return BTMTransactionManagerLookup.class.getName();
    }

    public EntityManagerFactory createEntityManagerFactory() {
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put("javax.persistence.jtaDataSource", this.getDataSourceName());
        overrides.put("hibernate.dialect", this.getHibernateDialect());
        overrides.put("hibernate.transaction.manager_lookup_class", this.getTransactionManagerLookupClass());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa", overrides);
        return emf;
    }
}

