/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.DescriptorExtensionList;
import hudson.XmlFile;
import hudson.drools.DBSettings;
import hudson.drools.EmbeddedDBSettings;
import hudson.drools.JBossDBSettings;
import hudson.drools.Script;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsManagement
extends ManagementLink {
    private List<Script> scripts;
    private DBSettings dbSettings;

    public DroolsManagement() {
        try {
            if (this.getConfigFile().exists()) {
                new XmlFile(this.getConfigFile()).unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getIconFileName() {
        return "/plugin/drools/icons/drools.gif";
    }

    public String getUrlName() {
        return "drools";
    }

    public String getDisplayName() {
        return "Drools Configuration";
    }

    public static DroolsManagement getInstance() {
        return (DroolsManagement)ManagementLink.all().get(DroolsManagement.class);
    }

    public void doSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        JSONObject form = req.getSubmittedForm();
        this.setScripts(req.bindJSONToList(Script.class, form.get("scripts")));
        String dbs = req.getParameter("dbSettings");
        int dbsIdx = Integer.parseInt(dbs);
        this.dbSettings = (DBSettings)((Descriptor)this.getDBSettingsDescriptors().get(dbsIdx)).newInstance(req, form.getJSONObject("dbSettings"));
        this.save();
        rsp.forwardToPreviousPage(req);
    }

    public List<Script> getScripts() {
        return this.scripts;
    }

    public void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    private File getConfigFile() {
        return new File(Hudson.getInstance().getRootDir(), "drools.xml");
    }

    public void save() throws IOException {
        new XmlFile(this.getConfigFile()).write((Object)this);
    }

    public Script getScript(String id) {
        for (Script script : this.scripts) {
            if (!id.equals(script.getId())) continue;
            return script;
        }
        return null;
    }

    public DBSettings getDbSettings() {
        if (this.dbSettings == null) {
            this.dbSettings = System.getProperty("jboss.home.dir") != null ? new JBossDBSettings() : new EmbeddedDBSettings();
        }
        return this.dbSettings;
    }

    public DescriptorExtensionList<DBSettings, Descriptor<DBSettings>> getDBSettingsDescriptors() {
        return DBSettings.all();
    }

    public void setDbSettings(DBSettings dbSettings) {
        this.dbSettings = dbSettings;
    }
}

