/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.Functions;
import hudson.drools.DroolsProject;
import hudson.drools.DroolsRun;
import hudson.drools.HumanTask;
import hudson.drools.NodeInstanceLog;
import hudson.drools.PluginImpl;
import hudson.drools.RuleFlowRenderer;
import hudson.drools.RunWrapper;
import hudson.drools.ScriptExecution;
import hudson.model.BallColor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.dom4j.DocumentException;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DroolsRun
extends Run<DroolsProject, DroolsRun>
implements Queue.Executable {
    private static Logger logger = Logger.getLogger(DroolsRun.class.getName());
    private List<HumanTask> humanTasks;
    private List<ScriptExecution> scriptExecutions;
    private List<NodeInstanceLog> logs;
    private transient PrintWriter logWriter;
    private long processInstanceId;
    private String processXML;
    private Status status;

    private Object readResolve() {
        for (HumanTask task : this.humanTasks) {
            task.setRun(this);
        }
        return this;
    }

    protected DroolsRun(DroolsProject project) throws IOException {
        super((Job)project);
        this.processXML = project.getProcessXML();
        this.humanTasks = new CopyOnWriteArrayList();
        this.status = Status.STARTED;
        this.scriptExecutions = new CopyOnWriteArrayList();
        this.logs = new CopyOnWriteArrayList();
    }

    public DroolsRun(DroolsProject project, File dir) throws IOException {
        super((Job)project, dir);
    }

    public List<HumanTask> getHumanTasks() {
        return this.humanTasks;
    }

    public void addHumanTask(HumanTask humanTask) {
        this.humanTasks.add(humanTask);
        humanTask.setRun(this);
        try {
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save!", e);
        }
    }

    public HumanTask getHumanTask(int workItemId) {
        for (HumanTask task : this.humanTasks) {
            if ((long)workItemId != task.getWorkItemId()) continue;
            return task;
        }
        return null;
    }

    public ProcessInstance getProcessInstance() {
        return PluginImpl.getInstance().getSession().getProcessInstance(this.processInstanceId);
    }

    public static DroolsRun getFromProcessInstance(long processInstanceId) {
        DroolsRun result = null;
        ProcessInstance processInstance = PluginImpl.getInstance().getSession().getProcessInstance(processInstanceId);
        if (processInstance != null) {
            result = DroolsRun.getFromProcessInstance((ProcessInstance)processInstance);
        }
        if (result == null) {
            for (DroolsProject project : Hudson.getInstance().getItems(DroolsProject.class)) {
                for (DroolsRun run : project.getBuilds()) {
                    if (run.getProcessInstanceId() != processInstanceId) continue;
                    return run;
                }
            }
        }
        return result;
    }

    public static DroolsRun getFromProcessInstance(ProcessInstance processInstance) {
        RunWrapper wrapper = (RunWrapper)((WorkflowProcessInstance)processInstance).getVariable("run");
        if (wrapper == null) {
            return null;
        }
        DroolsRun run = (DroolsRun)wrapper.getRun();
        return run;
    }

    public List<NodeInstanceLog> getLogs() {
        return this.logs;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl(this));
    }

    public String getUpUrl() {
        return Functions.getNearestAncestorUrl((StaplerRequest)Stapler.getCurrentRequest(), (Object)this.getParent()) + '/';
    }

    public synchronized RuleFlowRenderer getRuleFlowRenderer() {
        return new RuleFlowRenderer(this.processXML, this.getLogs());
    }

    public void doProcessInstanceImage(StaplerRequest req, StaplerResponse rsp) throws IOException, XPathExpressionException, DocumentException {
        ServletOutputStream output = rsp.getOutputStream();
        this.getRuleFlowRenderer().write((OutputStream)output);
        output.flush();
        output.close();
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void addScriptExecution(ScriptExecution execution) {
        this.scriptExecutions.add(execution);
    }

    public ScriptExecution getScriptExecution(int workItemId) {
        for (ScriptExecution execution : this.scriptExecutions) {
            if (execution.getWorkItemId() != (long)workItemId) continue;
            return execution;
        }
        return null;
    }

    public List<ScriptExecution> getScriptExecutions() {
        return this.scriptExecutions;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED;
    }

    public boolean isAborted() {
        return this.status == Status.ABORTED;
    }

    public boolean isRunning() {
        return this.status == Status.STARTED;
    }

    public BallColor getIconColor() {
        if (this.status == Status.STARTED) {
            return BallColor.BLUE_ANIME;
        }
        if (this.status == Status.ABORTED) {
            return BallColor.GREY;
        }
        return BallColor.BLUE;
    }

    public synchronized void markCompleted() {
        this.setStatus(Status.COMPLETED);
    }

    public synchronized void markAborted() {
        this.setStatus(Status.ABORTED);
    }

    private synchronized void setStatus(Status status) {
        this.status = status;
        PrintWriter logWriter = this.getLogWriter();
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace(logWriter);
        }
        logWriter.close();
    }

    public void addLog(NodeInstanceLog log) {
        this.logs.add(log);
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            try {
                this.logWriter = new PrintWriter((Writer)new FileWriter(this.getLogFile(), true), true);
            }
            catch (IOException e) {
                throw new RuntimeException("Error opening log file for reading", e);
            }
        }
        return this.logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDoCancel(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.checkPermission(Job.BUILD);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            PluginImpl.getInstance().getSession().abortProcessInstance(this.processInstanceId);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.setStatus(Status.ABORTED);
        rsp.sendRedirect2(req.getContextPath() + '/' + this.getUrl());
    }

    static /* synthetic */ long access$002(DroolsRun x0, long x1) {
        x0.processInstanceId = x1;
        return x0.processInstanceId;
    }
}

