/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.DroolsProject;
import hudson.drools.DroolsRun;
import hudson.drools.HumanTask;
import hudson.drools.PluginImpl;
import hudson.model.AbstractModelObject;
import hudson.model.BooleanParameterValue;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTask
extends AbstractModelObject
implements Serializable,
AccessControlled {
    private static final long serialVersionUID = 4611515699313881698L;
    private final List<ParameterDefinition> parameterDefinitions = new ArrayList();
    private final String displayName;
    private String actorId;
    private long workItemId;
    private transient DroolsRun run;
    private Status status = Status.NEW;
    private List<ParameterValue> answers;
    private boolean privateTask;

    public Status getStatus() {
        return this.status;
    }

    public boolean isPrivateTask() {
        return this.privateTask;
    }

    public HumanTask(String displayName, boolean privateTask) {
        this.displayName = displayName;
        this.privateTask = privateTask;
    }

    public void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            JSONObject jo = (JSONObject)o;
            String name = jo.getString("name");
            ParameterDefinition d = this.getParameterDefinition(name);
            if (d == null) {
                throw new IllegalArgumentException("No such parameter definition: " + name);
            }
            values.add(d.createValue(req, jo));
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (ParameterValue value : values) {
            if (value instanceof StringParameterValue) {
                results.put(value.getName(), ((StringParameterValue)value).value);
                continue;
            }
            if (!(value instanceof BooleanParameterValue)) continue;
            results.put(value.getName(), ((BooleanParameterValue)value).value);
        }
        ((PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class)).completeWorkItem(this.workItemId, results);
        this.answers = values;
        this.status = Status.COMPLETED;
        this.run.save();
        rsp.forwardToPreviousPage(req);
    }

    public void cancel() throws IOException {
        this.status = Status.CANCELED;
        this.run.save();
    }

    private ParameterDefinition getParameterDefinition(String name) {
        for (ParameterDefinition pd : this.parameterDefinitions) {
            if (!name.equals(pd.getName())) continue;
            return pd;
        }
        throw new IllegalArgumentException("Unknown parameter " + name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSearchUrl() {
        return null;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED;
    }

    public boolean isCanceled() {
        return this.status == Status.CANCELED;
    }

    public boolean isNew() {
        return this.status == Status.NEW;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public List<ParameterValue> getAnswers() {
        return this.answers;
    }

    public DroolsRun getRun() {
        return this.run;
    }

    public void setRun(DroolsRun run) {
        this.run = run;
    }

    public String getUrl() {
        return this.run.getUrl() + "scriptExecution/" + this.workItemId;
    }

    public String toString() {
        if (this.answers != null) {
            return String.format("HumanTask(%s) parameters: %s answers: %s", this.displayName, this.parameterDefinitions, this.answers);
        }
        return String.format("HumanTask(%s) parameters: %s", this.displayName, this.parameterDefinitions);
    }

    public String getActorId() {
        return this.actorId;
    }

    public User getActor() {
        return this.actorId != null ? User.get((String)this.actorId, (boolean)false) : null;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public boolean canRead() {
        if (this.privateTask) {
            return this.actorId == null || this.actorId.equals(User.current().getId());
        }
        return true;
    }

    public boolean canComplete() {
        if (this.status != Status.NEW) {
            return false;
        }
        if (this.actorId != null && User.current() != null) {
            return this.actorId.equals(User.current().getId());
        }
        return this.hasPermission(Job.BUILD);
    }

    public void checkPermission(Permission permission) throws AccessDeniedException {
        this.getACL().checkPermission(permission);
    }

    public ACL getACL() {
        return this.run.getACL();
    }

    public boolean hasPermission(Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    public static HumanTask getHumanTaskByWorkItemId(long workItemId) {
        for (DroolsProject p : Hudson.getInstance().getItems(DroolsProject.class)) {
            for (DroolsRun r : p.getBuilds()) {
                HumanTask humanTask = r.getHumanTask((int)workItemId);
                if (humanTask == null) continue;
                return humanTask;
            }
        }
        return null;
    }
}

