/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.GraphicsUtil;
import hudson.drools.NodeInstanceLog;
import hudson.drools.RuleFlowRenderer;
import hudson.drools.WorkItemAction;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RuleFlowRenderer {
    private static Color LINE_COLOR = Color.BLACK;
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Font FONT = new Font("Arial", 0, 11);
    public static final Color NODE_IN_PROGRESS_COLOR = new Color(193, 247, 160);
    public static final Color NODE_COMPLETE_COLOR = new Color(132, 217, 50);
    public static final Color BUILD_SUCCESS_COLOR = new Color(110, 110, 255);
    public static final Color BUILD_FAILED_COLOR = new Color(220, 80, 80);
    public static final Color BUILD_CANCELED_COLOR = new Color(200, 200, 200);
    public static final Color BUILD_UNSTABLE_COLOR = new Color(246, 248, 64);
    private Map<String, RFNode> nodes = new HashMap();
    private List<RFConnection> connections = new ArrayList();
    private List<RFConnection> compositeConnections = new ArrayList();
    private int width;
    private int height;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static Image endImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/process_stop.gif"));
    private static Image startImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/process_start.gif"));
    private static Image workItemImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/dsl.png"));
    private static Image joinImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/join.gif"));
    private static Image eventImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/event.gif"));
    private static Image humanTaskImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/human_task.gif"));

    public RuleFlowRenderer(String xml) {
        try {
            this.readResource(new SAXReader().read((Reader)new StringReader(xml)));
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Cannot parse workflow xml");
        }
    }

    public RuleFlowRenderer(String xml, List<NodeInstanceLog> logs) {
        this(xml);
        for (NodeInstanceLog log : logs) {
            Run run;
            String projectName;
            Job project;
            RFNode node = (RFNode)this.nodes.get(log.getNodeId());
            if (node == null) {
                System.out.println("unknown node for " + log);
                continue;
            }
            if (log.getType() == 0) {
                node.state = NodeState.IN_PROGRESS;
            } else if (log.getType() == 1) {
                node.state = NodeState.COMPLETED;
            }
            if (!(node instanceof Build) || (project = this.getJobUrl(projectName = ((Build)node).project)) == null || (run = WorkItemAction.findRun((Job)project, (long)log.getProcessInstanceId())) == null) continue;
            Build.access$002((Build)((Build)node), (Run)run);
        }
    }

    private Job getJobUrl(String projectName) {
        return Hudson.getInstance() != null ? (Job)Hudson.getInstance().getItem(projectName) : null;
    }

    private void readResource(Document document) throws DocumentException {
        int maxX = 0;
        int maxY = 0;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        Element root = document.getRootElement();
        Iterator it = root.element("nodes").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            int x = Integer.parseInt(el.attributeValue("x"));
            int y = Integer.parseInt(el.attributeValue("y"));
            int width = Integer.parseInt(el.attributeValue("width"));
            int height = Integer.parseInt(el.attributeValue("height"));
            maxX = Math.max(maxX, x + width);
            maxY = Math.max(maxY, y + height);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
        }
        int offsetX = minX - 5;
        int offsetY = minY - 5;
        it = root.element("nodes").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            RFNode node = this.createNode(el, offsetX, offsetY);
            this.nodes.put(node.id, node);
        }
        this.width = maxX - minX + 10;
        this.height = maxY - minY + 10;
        it = root.element("connections").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String from = el.attributeValue("from");
            String to = el.attributeValue("to");
            this.connections.add(new RFConnection((RFNode)this.nodes.get(from), (RFNode)this.nodes.get(to)));
        }
    }

    private RFNode createNode(Element el, int offsetX, int offsetY) {
        HumanTask node;
        int height;
        String type = el.getName();
        String name = el.attributeValue("name");
        String id = el.attributeValue("id");
        int x = Integer.parseInt(el.attributeValue("x")) - offsetX;
        int y = Integer.parseInt(el.attributeValue("y")) - offsetY;
        int width = el.attributeValue("width") != null ? Integer.parseInt(el.attributeValue("width")) : 80;
        int n = height = el.attributeValue("height") != null ? Integer.parseInt(el.attributeValue("height")) : 40;
        if ("workItem".equals(type)) {
            String workName = el.element("work").attributeValue("name");
            if ("Script".equals(workName)) {
                node = new Script(this, type, name, id, x, y, width, height);
            } else if ("Build".equals(workName)) {
                Iterator eit = el.element("work").elementIterator();
                String project = null;
                while (eit.hasNext()) {
                    Element param = (Element)eit.next();
                    if (!"Project".equals(param.attributeValue("name"))) continue;
                    project = param.elementText("value");
                }
                node = new Build(this, type, name, id, project, x, y, width, height);
            } else {
                node = new WorkItem(this, type, name, id, x, y, width, height);
            }
        } else if ("humanTask".equals(type)) {
            node = new HumanTask(this, type, name, id, x, y, width, height);
        } else if ("start".equals(type)) {
            node = new Start(this, type, name, id, x, y, width, height);
        } else if ("end".equals(type)) {
            node = new End(this, type, name, id, x, y, width, height);
        } else if ("split".equals(type)) {
            node = new Split(this, type, name, id, x, y, width, height);
        } else if ("join".equals(type)) {
            node = new Split(this, type, name, id, x, y, width, height);
        } else if ("eventNode".equals(type)) {
            node = new Event(this, type, name, id, x, y, width, height);
        } else if ("forEach".equals(type)) {
            node = new ForEach(this, type, name, id, x, y, width, height);
            Iterator it = el.element("nodes").elementIterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                RFNode child = this.createNode(e, -x, -y);
                this.nodes.put(node.id + ":2:" + child.id, child);
            }
            it = el.element("connections").elementIterator();
            while (it.hasNext()) {
                Element conn = (Element)it.next();
                String from = node.id + ":2:" + conn.attributeValue("from");
                String to = node.id + ":2:" + conn.attributeValue("to");
                this.compositeConnections.add(new RFConnection((RFNode)this.nodes.get(from), (RFNode)this.nodes.get(to)));
            }
        } else {
            node = new RFNode(this, type, name, id, x, y, width, height);
        }
        return node;
    }

    public Collection<RFNode> getNodes() {
        return this.nodes.values();
    }

    public void paint(Graphics2D g2) {
        Rectangle2D.Double toRect;
        Rectangle2D.Double fromRect;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (RFConnection connection : this.connections) {
            fromRect = RFConnection.access$100((RFConnection)connection).asRectangle();
            toRect = RFConnection.access$200((RFConnection)connection).asRectangle();
            RuleFlowRenderer.paintLine((Graphics2D)g2, (Rectangle2D.Double)fromRect, (Rectangle2D.Double)toRect);
        }
        for (RFNode node : this.nodes.values()) {
            if (!(node instanceof ForEach)) continue;
            node.paint(g2);
        }
        for (RFConnection connection : this.compositeConnections) {
            fromRect = RFConnection.access$100((RFConnection)connection).asRectangle();
            toRect = RFConnection.access$200((RFConnection)connection).asRectangle();
            RuleFlowRenderer.paintLine((Graphics2D)g2, (Rectangle2D.Double)fromRect, (Rectangle2D.Double)toRect);
        }
        for (RFNode node : this.nodes.values()) {
            if (node instanceof ForEach) continue;
            node.paint(g2);
        }
    }

    public static void paintLine(Graphics2D g2, Rectangle2D.Double from, Rectangle2D.Double to) {
        Point2D.Double fromRectCenter = new Point2D.Double(from.getCenterX(), from.getCenterY());
        Point2D.Double toRectCenter = new Point2D.Double(to.getCenterX(), to.getCenterY());
        Line2D.Double line = new Line2D.Double(fromRectCenter, toRectCenter);
        Point2D.Double p1 = new Point2D.Double();
        GraphicsUtil.getLineRectangleIntersection((Rectangle2D.Double)from, (Line2D.Double)line, (Point2D.Double)p1);
        Point2D.Double p2 = new Point2D.Double();
        GraphicsUtil.getLineRectangleIntersection((Rectangle2D.Double)to, (Line2D.Double)line, (Point2D.Double)p2);
        RuleFlowRenderer.drawArrow((Graphics2D)g2, (Line2D.Double)line, (float)1.0f, (boolean)true);
    }

    public static void drawArrow(Graphics2D g2d, Line2D.Double line, float stroke, boolean arrow) {
        int xCenter = (int)line.getX1();
        int yCenter = (int)line.getY1();
        double x = line.getX2();
        double y = line.getY2();
        double aDir = Math.atan2((double)xCenter - x, (double)yCenter - y);
        int i1 = 12 + (int)(stroke * 2.0f);
        int i2 = 6 + (int)stroke;
        Line2D.Double base = new Line2D.Double(x + (double)RuleFlowRenderer.xCor((int)i1, (double)(aDir + 0.5)), y + (double)RuleFlowRenderer.yCor((int)i1, (double)(aDir + 0.5)), x + (double)RuleFlowRenderer.xCor((int)i1, (double)(aDir - 0.5)), y + (double)RuleFlowRenderer.yCor((int)i1, (double)(aDir - 0.5)));
        Point2D.Double intersect = new Point2D.Double();
        GraphicsUtil.getLineLineIntersection((Line2D.Double)line, (Line2D.Double)base, (Point2D.Double)intersect);
        g2d.setPaint(LINE_COLOR);
        if (arrow) {
            g2d.draw(new Line2D.Double(xCenter, yCenter, intersect.x, intersect.y));
            g2d.setStroke(new BasicStroke(1.0f));
            Polygon tmpPoly = new Polygon();
            tmpPoly.addPoint((int)x, (int)y);
            tmpPoly.addPoint((int)x + RuleFlowRenderer.xCor((int)i1, (double)(aDir + 0.5)), (int)y + RuleFlowRenderer.yCor((int)i1, (double)(aDir + 0.5)));
            tmpPoly.addPoint((int)x + RuleFlowRenderer.xCor((int)i1, (double)(aDir - 0.5)), (int)y + RuleFlowRenderer.yCor((int)i1, (double)(aDir - 0.5)));
            tmpPoly.addPoint((int)x, (int)y);
            g2d.drawPolygon(tmpPoly);
        } else {
            g2d.draw(new Line2D.Double(xCenter, yCenter, x, y));
        }
    }

    private static int yCor(int len, double dir) {
        return (int)((double)len * Math.cos(dir));
    }

    private static int xCor(int len, double dir) {
        return (int)((double)len * Math.sin(dir));
    }

    public String getNodeName(String id) {
        RFNode node = (RFNode)this.nodes.get(id);
        return node != null ? node.name : null;
    }

    public void write(OutputStream output) throws IOException {
        BufferedImage aimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = aimg.createGraphics();
        this.paint(g);
        g.dispose();
        ImageIO.write((RenderedImage)aimg, "png", output);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static void paintBall(Graphics2D g2, Color c) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int diameter = 16;
        Paint oldPaint = g2.getPaint();
        g2.setColor(c);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        Paint p = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.4f), 0.0f, diameter, new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), 0.0f, diameter, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new RadialGradientPaint(new Point2D.Double((double)diameter * 0.4, (double)diameter * 0.45), (float)diameter / 2.0f, new float[]{0.0f, 0.95f}, new Color[]{new Color(c.getRed(), c.getGreen(), c.getBlue(), 127), new Color(0.0f, 0.0f, 0.0f, 0.0f)});
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new RadialGradientPaint(new Point2D.Double((double)diameter / 2.0, (double)diameter * 1.5), (float)diameter / 2.3f, new Point2D.Double((double)diameter / 2.0, (double)diameter * 1.75 + 6.0), new float[]{0.0f, 0.8f}, new Color[]{new Color(c.getRed(), c.getGreen(), c.getBlue(), 255), new Color(c.getRed(), c.getGreen(), c.getBlue(), 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, AffineTransform.getScaleInstance(1.0, 0.5));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        g2.setPaint(oldPaint);
    }

    static /* synthetic */ Color access$300() {
        return LINE_COLOR;
    }

    static /* synthetic */ Color access$400() {
        return TEXT_COLOR;
    }

    static /* synthetic */ Font access$500() {
        return FONT;
    }

    static /* synthetic */ Image access$600() {
        return workItemImage;
    }

    static /* synthetic */ Image access$700() {
        return humanTaskImage;
    }

    static /* synthetic */ Job access$800(RuleFlowRenderer x0, String x1) {
        return x0.getJobUrl(x1);
    }

    static /* synthetic */ Image access$900() {
        return joinImage;
    }

    static /* synthetic */ Image access$1000() {
        return eventImage;
    }

    static /* synthetic */ Image access$1100() {
        return startImage;
    }

    static /* synthetic */ Image access$1200() {
        return endImage;
    }
}

