/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.DroolsCause;
import hudson.drools.DroolsProject;
import hudson.drools.DroolsRun;
import hudson.drools.PluginImpl;
import hudson.drools.RunWrapper;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemManager;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemAction
extends ParametersAction {
    private static final Logger logger = Logger.getLogger(WorkItemAction.class.getName());
    private final long workItemId;
    private final long processInstanceId;
    private final String projectName;
    private Run<?, ?> run;
    private final boolean completeWhenUnstable;
    private final boolean completeWhenFailed;
    private boolean completed = false;

    public WorkItemAction(long workItemId, long processInstanceId, String projectName, boolean completeWhenFailed, boolean completeWhenUnstable, List<ParameterValue> parameters) {
        super(parameters);
        this.workItemId = workItemId;
        this.processInstanceId = processInstanceId;
        this.projectName = projectName;
        this.completeWhenUnstable = completeWhenUnstable;
        this.completeWhenFailed = completeWhenFailed;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void scheduleBuild() {
        AbstractProject project = (AbstractProject)Hudson.getInstance().getItem(this.projectName);
        if (project == null) {
            throw new IllegalArgumentException("project " + this.projectName + " does not exist (work item " + this.workItemId + ")");
        }
        project.scheduleBuild(0, (Cause)new DroolsCause("Started by workflow"), new Action[]{this});
    }

    public void buildComplete(Run r) {
        this.run = r;
        this.save();
        if (!this.completeWhenUnstable && r.getResult() == Result.UNSTABLE) {
            return;
        }
        if (!this.completeWhenFailed && r.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return;
        }
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StatefulKnowledgeSession session = PluginImpl.getInstance().getSession();
            WorkItemManager workItemManager = session.getWorkItemManager();
            HashMap<String, RunWrapper> result = new HashMap<String, RunWrapper>();
            result.put("Build", new RunWrapper(this.run));
            workItemManager.completeWorkItem(this.workItemId, result);
            this.completed = true;
            this.save();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while finalizing " + this.run.getDisplayName() + " and completing WorkItem " + this.workItemId, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void save() {
        try {
            this.run.save();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error while saving run", e);
        }
    }

    public void doRestart(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.run.checkPermission(Job.BUILD);
        if (this.run == null || !this.run.getResult().isWorseOrEqualTo(Result.UNSTABLE)) {
            throw new IllegalArgumentException("Cannot restart a build that did not fail.");
        }
        new WorkItemAction(this.workItemId, this.processInstanceId, this.projectName, this.completeWhenFailed, this.completeWhenUnstable, this.getParameters()).scheduleBuild();
        rsp.forwardToPreviousPage(req);
    }

    public void doComplete(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.run.checkPermission(Job.BUILD);
        if (this.run == null) {
            throw new IllegalArgumentException("Cannot complete before the build is done");
        }
        this.complete();
        rsp.forwardToPreviousPage(req);
    }

    public String getDisplayName() {
        return "Work Item";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "workItem";
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void setRun(Run<?, ?> run) {
        this.run = run;
    }

    public boolean isAllowRestart() {
        DroolsRun droolsRun = this.getDroolsRun();
        if (droolsRun == null || !droolsRun.isRunning()) {
            return false;
        }
        if (this.run == null) {
            return false;
        }
        if (this.run.getResult() == Result.UNSTABLE) {
            return !this.completeWhenUnstable;
        }
        if (this.run.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return !this.completeWhenFailed;
        }
        return false;
    }

    public boolean isAllowComplete() {
        DroolsRun droolsRun = this.getDroolsRun();
        return !this.completed && this.run != null && droolsRun != null && !droolsRun.isCompleted();
    }

    public DroolsRun getDroolsRun() {
        for (DroolsProject project : Hudson.getInstance().getItems(DroolsProject.class)) {
            for (DroolsRun run : project.getBuilds()) {
                if (run.getProcessInstanceId() != this.processInstanceId) continue;
                return run;
            }
        }
        return null;
    }

    public static Run findRun(Job<?, ?> project, long processInstanceId) {
        for (Run run : project.getBuilds()) {
            WorkItemAction w = (WorkItemAction)run.getAction(WorkItemAction.class);
            if (w == null || w.processInstanceId != processInstanceId) continue;
            return run;
        }
        return null;
    }

    public String getUrl() {
        return this.getRun().getUrl() + "/workItem";
    }

    public boolean shouldSchedule(List<Action> actions) {
        return true;
    }
}

