/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.RunWrapper;
import hudson.drools.WorkItemAction;
import hudson.model.BooleanParameterValue;
import hudson.model.ParameterValue;
import hudson.model.RunParameterValue;
import hudson.model.StringParameterValue;
import java.util.ArrayList;
import java.util.Map;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class BuildWorkItemHandler
implements WorkItemHandler {
    private static final String COMPLETE_WHEN_UNSTABLE = "Complete when unstable";
    private static final String COMPLETE_WHEN_FAILED = "Complete when failed";
    private static final String PROJECT = "Project";

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String projectName = (String)workItem.getParameter(PROJECT);
        Boolean completeWhenFailed = (Boolean)workItem.getParameter(COMPLETE_WHEN_FAILED);
        Boolean completeWhenUnstable = (Boolean)workItem.getParameter(COMPLETE_WHEN_UNSTABLE);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (Map.Entry parameter : workItem.getParameters().entrySet()) {
            if (parameter.getValue() instanceof String) {
                values.add((ParameterValue)new StringParameterValue((String)parameter.getKey(), (String)parameter.getValue(), "drools parameter"));
            }
            if (parameter.getValue() instanceof Boolean) {
                values.add((ParameterValue)new BooleanParameterValue((String)parameter.getKey(), ((Boolean)parameter.getValue()).booleanValue(), "drools parameter"));
            }
            if (!(parameter.getValue() instanceof RunWrapper)) continue;
            values.add((ParameterValue)new RunParameterValue((String)parameter.getKey(), ((RunWrapper)parameter.getValue()).getRun().getExternalizableId(), "drools parameter"));
        }
        new WorkItemAction(workItem.getId(), workItem.getProcessInstanceId(), projectName, completeWhenFailed != null ? completeWhenFailed : false, completeWhenUnstable != null ? completeWhenUnstable : false, values).scheduleBuild();
    }
}

