/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import antlr.ANTLRException;
import hudson.drools.DroolsRun;
import hudson.drools.PluginImpl;
import hudson.drools.RuleFlowRenderer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.scheduler.CronTabList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.xml.xpath.XPathExpressionException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.io.Resource;
import org.drools.io.impl.ReaderResource;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsProject
extends Job<DroolsProject, DroolsRun>
implements TopLevelItem,
Queue.Task,
BuildableItem {
    private boolean disabled;
    private transient String processId;
    private String processXML;
    private String triggerSpec;
    private transient CronTabList tabs;
    protected transient RunMap<DroolsRun> builds = new RunMap();
    private transient WeakReference<RuleFlowRenderer> renderer;

    protected DroolsProject(ItemGroup<?> parent, String name) {
        super(parent, name);
    }

    protected SortedMap<Integer, ? extends DroolsRun> _getRuns() {
        return this.builds.getView();
    }

    public boolean isBuildable() {
        return true;
    }

    protected void removeRun(DroolsRun run) {
        this.builds.remove((Run)run);
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.builds = new RunMap();
        this.builds.load((Job)this, (RunMap.Constructor)new RunMap.Constructor<DroolsRun>(){

            public DroolsRun create(File dir) throws IOException {
                DroolsRun newBuild = new DroolsRun(DroolsProject.this, dir);
                DroolsProject.this.builds.put((Run)newBuild);
                return newBuild;
            }
        });
        if (this.triggerSpec != null) {
            try {
                this.tabs = CronTabList.create((String)this.triggerSpec);
            }
            catch (ANTLRException e) {
                e.printStackTrace();
            }
        }
        if (PluginImpl.getInstance().getKnowledgeBase() != null) {
            this.updateProcess();
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(DroolsProject.class);
    }

    public Hudson getParent() {
        return Hudson.getInstance();
    }

    public synchronized void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        JSONObject form = req.getSubmittedForm();
        String processXML = form.getString("processXML");
        this.processId = this.updateProcess(processXML);
        this.processXML = processXML;
        this.triggerSpec = form.getString("triggerSpec");
        if (!StringUtils.isEmpty((String)this.triggerSpec)) {
            try {
                this.tabs = CronTabList.create((String)this.triggerSpec);
            }
            catch (ANTLRException e) {
                e.printStackTrace();
            }
        } else {
            this.tabs = null;
            this.triggerSpec = null;
        }
        super.doConfigSubmit(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateProcess(String processXML) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new PackageBuilderConfiguration());
            kbuilder.add((Resource)new ReaderResource((Reader)new StringReader(processXML)), ResourceType.DRF);
            KnowledgeBuilderErrors errors = kbuilder.getErrors();
            StringBuilder sb = new StringBuilder();
            if (errors.size() > 0) {
                for (KnowledgeBuilderError error : errors) {
                    sb.append(error.getMessage()).append("\n");
                }
                throw new IllegalArgumentException("Could not parse knowledge:\n" + sb);
            }
            Collection knowledgePackages = kbuilder.getKnowledgePackages();
            Process process = (Process)((KnowledgePackage)knowledgePackages.iterator().next()).getProcesses().iterator().next();
            this.processId = process.getId();
            PluginImpl.getInstance().getKnowledgeBase().addKnowledgePackages(knowledgePackages);
            String string = this.processId;
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void updateProcess() {
        this.processId = this.updateProcess(this.processXML);
    }

    public void validateWorkflow() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new PackageBuilderConfiguration());
        kbuilder.add((Resource)new ReaderResource((Reader)new StringReader(this.processXML)), ResourceType.DRF);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(BUILD);
        Cause.UserCause cause = new Cause.UserCause();
        this.scheduleBuild((Cause)cause);
        rsp.forwardToPreviousPage(req);
    }

    public boolean scheduleBuild(Cause cause, Action ... actions) {
        if (this.isDisabled()) {
            return false;
        }
        ArrayList<Action> queueActions = new ArrayList<Action>(Arrays.asList(actions));
        if (cause != null) {
            queueActions.add((Action)new CauseAction(cause));
        }
        return Hudson.getInstance().getQueue().add((Queue.Task)this, 0, queueActions.toArray(new Action[queueActions.size()]));
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public void checkAbortPermission() {
        this.checkPermission(AbstractProject.ABORT);
    }

    public Queue.Executable createExecutable() throws IOException {
        DroolsRun run = new DroolsRun(this);
        this.builds.put((Run)run);
        return run;
    }

    public Label getAssignedLabel() {
        return null;
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public Node getLastBuiltOn() {
        return null;
    }

    public String getWhyBlocked() {
        return null;
    }

    public boolean hasAbortPermission() {
        return false;
    }

    public boolean isBuildBlocked() {
        return false;
    }

    public ResourceList getResourceList() {
        return new ResourceList();
    }

    public String getProcessId() {
        return this.processId;
    }

    public synchronized RuleFlowRenderer getRuleFlowRenderer() {
        if (this.renderer == null || this.renderer.get() == null) {
            this.renderer = new WeakReference<RuleFlowRenderer>(new RuleFlowRenderer(this.processXML));
        }
        return (RuleFlowRenderer)this.renderer.get();
    }

    public void doProcessInstanceImage(StaplerRequest req, StaplerResponse rsp) throws IOException, XPathExpressionException, DocumentException {
        ServletOutputStream output = rsp.getOutputStream();
        this.getRuleFlowRenderer().write((OutputStream)output);
        output.flush();
        output.close();
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Exported
    public String getProcessXML() {
        return this.processXML;
    }

    @Exported
    public String getTriggerSpec() {
        return this.triggerSpec;
    }

    public boolean scheduleBuild() {
        return this.scheduleBuild(null, new Action[0]);
    }

    public boolean scheduleBuild(Cause c) {
        return this.scheduleBuild(c, new Action[0]);
    }

    public boolean scheduleBuild(int quietPeriod) {
        return this.scheduleBuild(null, new Action[0]);
    }

    public boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.scheduleBuild(null, new Action[]{new CauseAction(c)});
    }

    public CronTabList getTabs() {
        return this.tabs;
    }

    public void doSubmitWorkflow(StaplerRequest request, StaplerResponse rsp) throws IOException {
        this.checkPermission(CONFIGURE);
        if (!"POST".equals(request.getMethod())) {
            rsp.sendError(405, "POST expected");
            return;
        }
        String processXML = IOUtils.toString((InputStream)request.getInputStream());
        this.processId = this.updateProcess(processXML);
        this.processXML = processXML;
        this.save();
    }

    protected void performDelete() throws IOException, InterruptedException {
        PluginImpl.getInstance().getKnowledgeBase().removeProcess(this.processId);
    }

    private DroolsProject checkAlreadyDeployed(String processId) {
        for (DroolsProject project : Hudson.getInstance().getItems(DroolsProject.class)) {
            if (project == this || !project.getProcessId().equals(processId)) continue;
            return project;
        }
        return null;
    }

    public static final class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return "Drools Project";
        }

        public DroolsProject newInstance(String name) {
            return new DroolsProject((ItemGroup<?>)Hudson.getInstance(), name);
        }

        public String[] getAvailableProcessIds() {
            return new String[]{"agility-ris-release-workflow", "asb-trunk-release-workflow"};
        }
    }
}

