/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.util.BuilderSupport;
import hudson.drools.HumanTask;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.StringParameterDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class HumanTaskBuilder
extends BuilderSupport {
    private HumanTask task;
    private final List<String> validTypes = Arrays.asList("boolean", "string", "choice");

    protected Object createNode(Object name) {
        throw new IllegalArgumentException("HumanTaskBuilder.createNode(" + name + ")");
    }

    protected Object createNode(Object name, Object value) {
        throw new IllegalArgumentException("unexpected: " + name + "(" + value + ")");
    }

    protected Object createNode(Object name, Map attributes) {
        if (this.task == null) {
            Boolean _privateTask = (Boolean)attributes.get("private");
            boolean privateTask = _privateTask != null ? _privateTask : false;
            String title = (String)attributes.get("title");
            this.task = new HumanTask(title, privateTask);
            return this.task;
        }
        Object type = attributes.get("type");
        if (!this.validTypes.contains(type)) {
            throw new IllegalArgumentException(type + " is not a valid type " + this.validTypes);
        }
        String description = (String)attributes.get("description");
        if ("string".equals(type)) {
            return new StringParameterDefinition((String)name, (String)attributes.get("defaultValue"), description);
        }
        if ("boolean".equals(type)) {
            Boolean defaultValue = (Boolean)attributes.get("defaultValue");
            return new BooleanParameterDefinition((String)name, defaultValue != null ? defaultValue : false, description);
        }
        if ("choice".equals(type)) {
            List choices = (List)attributes.get("choices");
            return new ChoiceParameterDefinition((String)name, choices.toArray(new String[choices.size()]), description);
        }
        throw new AssertionError((Object)"can't get here");
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        throw new IllegalArgumentException("unexpected HumanTaskBuilder.createNode(" + name + "," + attributes + "," + value + ")");
    }

    protected void setParent(Object parent, Object child) {
        if (!(parent instanceof HumanTask) || !(child instanceof ParameterDefinition)) {
            throw new IllegalArgumentException("unexpected HumanTaskBuilder.setParent(" + parent + "," + child + ")");
        }
        ((HumanTask)parent).getParameterDefinitions().add((ParameterDefinition)child);
    }

    public static void main(String[] args) {
        String script = "def task = { title,closure -> new hudson.drools.HumanTaskBuilder().task(title, closure) }\n";
        script = script + "task(title:\"A Question\",private:false) {\n";
        script = script + "reply type: \"boolean\", description: \"description\", defaultValue:false\n";
        script = script + "}\n";
        GroovyShell shell = new GroovyShell(HumanTaskBuilder.class.getClassLoader());
        GroovyCodeSource codeSource = new GroovyCodeSource(script, "name", ".");
        HumanTask question = (HumanTask)shell.evaluate(codeSource);
        System.out.println(question.isPrivateTask());
    }
}

