/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.Plugin;
import hudson.drools.BuildWorkItemHandler;
import hudson.drools.DroolsManagement;
import hudson.drools.DroolsProject;
import hudson.drools.EmailWorkItemHandler;
import hudson.drools.HumanTaskHandler;
import hudson.drools.RuleFlowRenderer;
import hudson.drools.RunWrapper;
import hudson.drools.ScriptHandler;
import hudson.drools.WorkItemAction;
import hudson.drools.WorkingMemoryHudsonLogger;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.impl.EnvironmentFactory;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    private StatefulKnowledgeSession ksession;
    private KnowledgeBase kbase;
    public static final boolean PERSISTENCE = true;
    private static PluginImpl INSTANCE;

    public void start() throws Exception {
        INSTANCE = this;
        RuleFlowRenderer.class.getName();
        RunListener.all().add((Object)new RunListener(Run.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFinalized(Run r) {
                WorkItemAction action = (WorkItemAction)r.getAction(WorkItemAction.class);
                if (action != null) {
                    action.buildComplete(r);
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    PluginImpl.this.getSession().signalEvent("BuildComplete:" + r.getParent().getName(), (Object)new RunWrapper(r));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        });
        ItemListener.all().add((Object)new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLoaded() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(PluginImpl.class.getClassLoader());
                try {
                    DroolsManagement.getInstance().getDbSettings().start();
                    PluginImpl.this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
                    PluginImpl.this.ksession = PluginImpl.this.createSession();
                    for (DroolsProject p : Hudson.getInstance().getItems(DroolsProject.class)) {
                        p.updateProcess();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        });
    }

    public void stop() throws Exception {
        this.ksession.dispose();
        DroolsManagement.getInstance().getDbSettings().stop();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kbase;
    }

    public StatefulKnowledgeSession getSession() {
        return this.ksession;
    }

    private StatefulKnowledgeSession createSession() {
        SessionConfiguration conf = new SessionConfiguration();
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)DroolsManagement.getInstance().getDbSettings().createEntityManagerFactory());
        StatefulKnowledgeSession ksession = this.kbase.newStatefulKnowledgeSession((KnowledgeSessionConfiguration)conf, env);
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
        new WorkingMemoryHudsonLogger((KnowledgeRuntimeEventManager)ksession);
        WorkItemManager workItemManager = ksession.getWorkItemManager();
        workItemManager.registerWorkItemHandler("Build", (WorkItemHandler)new BuildWorkItemHandler());
        workItemManager.registerWorkItemHandler("Human Task", (WorkItemHandler)new HumanTaskHandler());
        workItemManager.registerWorkItemHandler("Script", (WorkItemHandler)new ScriptHandler());
        workItemManager.registerWorkItemHandler("E-Mail", (WorkItemHandler)new EmailWorkItemHandler());
        return ksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeWorkItem(long workItemId, Map<String, Object> results) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.getSession().getWorkItemManager().completeWorkItem(workItemId, results);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static PluginImpl getInstance() {
        return INSTANCE;
    }

    public void doWorkflowProjects(StaplerRequest req, StaplerResponse rsp) throws IOException {
        PrintWriter pw = new PrintWriter((OutputStream)rsp.getOutputStream());
        for (DroolsProject project : Hudson.getInstance().getItems(DroolsProject.class)) {
            pw.println(project.getName());
            System.out.println(project.getName());
        }
        pw.flush();
    }
}

