/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.GraphicsUtil;
import hudson.drools.NodeInstanceLog;
import hudson.drools.WorkItemAction;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowRenderer {
    private static Color LINE_COLOR = Color.BLACK;
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Font FONT = new Font("Arial", 0, 11);
    public static final Color NODE_IN_PROGRESS_COLOR = new Color(193, 247, 160);
    public static final Color NODE_COMPLETE_COLOR = new Color(132, 217, 50);
    public static final Color BUILD_SUCCESS_COLOR = new Color(110, 110, 255);
    public static final Color BUILD_FAILED_COLOR = new Color(220, 80, 80);
    public static final Color BUILD_CANCELED_COLOR = new Color(200, 200, 200);
    public static final Color BUILD_UNSTABLE_COLOR = new Color(246, 248, 64);
    private Map<String, RFNode> nodes = new HashMap<String, RFNode>();
    private List<RFConnection> connections = new ArrayList<RFConnection>();
    private List<RFConnection> compositeConnections = new ArrayList<RFConnection>();
    private int width;
    private int height;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static Image endImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/process_stop.gif"));
    private static Image startImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/process_start.gif"));
    private static Image workItemImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/dsl.png"));
    private static Image joinImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/join.gif"));
    private static Image eventImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/event.gif"));
    private static Image humanTaskImage = toolkit.getImage(RuleFlowRenderer.class.getResource("/icons/human_task.gif"));

    public RuleFlowRenderer(String xml) {
        try {
            this.readResource(new SAXReader().read((Reader)new StringReader(xml)));
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Cannot parse workflow xml");
        }
    }

    public RuleFlowRenderer(String xml, List<NodeInstanceLog> logs) {
        this(xml);
        for (NodeInstanceLog log : logs) {
            Run run;
            String projectName;
            Job project;
            RFNode node = this.nodes.get(log.getNodeId());
            if (node == null) {
                System.out.println("unknown node for " + log);
                continue;
            }
            if (log.getType() == 0) {
                node.state = NodeState.IN_PROGRESS;
            } else if (log.getType() == 1) {
                node.state = NodeState.COMPLETED;
            }
            if (!(node instanceof Build) || (project = this.getJobUrl(projectName = ((Build)node).project)) == null || (run = WorkItemAction.findRun(project, log.getProcessInstanceId())) == null) continue;
            ((Build)node).run = run;
        }
    }

    private Job getJobUrl(String projectName) {
        return Hudson.getInstance() != null ? (Job)Hudson.getInstance().getItem(projectName) : null;
    }

    private void readResource(Document document) throws DocumentException {
        int maxX = 0;
        int maxY = 0;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        Element root = document.getRootElement();
        Iterator it = root.element("nodes").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            int x = Integer.parseInt(el.attributeValue("x"));
            int y = Integer.parseInt(el.attributeValue("y"));
            int width = Integer.parseInt(el.attributeValue("width"));
            int height = Integer.parseInt(el.attributeValue("height"));
            maxX = Math.max(maxX, x + width);
            maxY = Math.max(maxY, y + height);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
        }
        int offsetX = minX - 5;
        int offsetY = minY - 5;
        it = root.element("nodes").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            RFNode node = this.createNode(el, offsetX, offsetY);
            this.nodes.put(node.id, node);
        }
        this.width = maxX - minX + 10;
        this.height = maxY - minY + 10;
        it = root.element("connections").elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String from = el.attributeValue("from");
            String to = el.attributeValue("to");
            this.connections.add(new RFConnection(this.nodes.get(from), this.nodes.get(to)));
        }
    }

    private RFNode createNode(Element el, int offsetX, int offsetY) {
        RFNode node;
        int height;
        String type = el.getName();
        String name = el.attributeValue("name");
        String id = el.attributeValue("id");
        int x = Integer.parseInt(el.attributeValue("x")) - offsetX;
        int y = Integer.parseInt(el.attributeValue("y")) - offsetY;
        int width = el.attributeValue("width") != null ? Integer.parseInt(el.attributeValue("width")) : 80;
        int n = height = el.attributeValue("height") != null ? Integer.parseInt(el.attributeValue("height")) : 40;
        if ("workItem".equals(type)) {
            String workName = el.element("work").attributeValue("name");
            if ("Script".equals(workName)) {
                node = new Script(type, name, id, x, y, width, height);
            } else if ("Build".equals(workName)) {
                Iterator eit = el.element("work").elementIterator();
                String project = null;
                while (eit.hasNext()) {
                    Element param = (Element)eit.next();
                    if (!"Project".equals(param.attributeValue("name"))) continue;
                    project = param.elementText("value");
                }
                node = new Build(type, name, id, project, x, y, width, height);
            } else {
                node = new WorkItem(type, name, id, x, y, width, height);
            }
        } else if ("humanTask".equals(type)) {
            node = new HumanTask(type, name, id, x, y, width, height);
        } else if ("start".equals(type)) {
            node = new Start(type, name, id, x, y, width, height);
        } else if ("end".equals(type)) {
            node = new End(type, name, id, x, y, width, height);
        } else if ("split".equals(type)) {
            node = new Split(type, name, id, x, y, width, height);
        } else if ("join".equals(type)) {
            node = new Split(type, name, id, x, y, width, height);
        } else if ("eventNode".equals(type)) {
            node = new Event(type, name, id, x, y, width, height);
        } else if ("forEach".equals(type)) {
            node = new ForEach(type, name, id, x, y, width, height);
            Iterator it = el.element("nodes").elementIterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                RFNode child = this.createNode(e, -x, -y);
                this.nodes.put(node.id + ":2:" + child.id, child);
            }
            it = el.element("connections").elementIterator();
            while (it.hasNext()) {
                Element conn = (Element)it.next();
                String from = node.id + ":2:" + conn.attributeValue("from");
                String to = node.id + ":2:" + conn.attributeValue("to");
                this.compositeConnections.add(new RFConnection(this.nodes.get(from), this.nodes.get(to)));
            }
        } else {
            node = new RFNode(type, name, id, x, y, width, height);
        }
        return node;
    }

    public Collection<RFNode> getNodes() {
        return this.nodes.values();
    }

    public void paint(Graphics2D g2) {
        Rectangle2D.Double toRect;
        Rectangle2D.Double fromRect;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (RFConnection connection : this.connections) {
            fromRect = connection.from.asRectangle();
            toRect = connection.to.asRectangle();
            RuleFlowRenderer.paintLine(g2, fromRect, toRect);
        }
        for (RFNode node : this.nodes.values()) {
            if (!(node instanceof ForEach)) continue;
            node.paint(g2);
        }
        for (RFConnection connection : this.compositeConnections) {
            fromRect = connection.from.asRectangle();
            toRect = connection.to.asRectangle();
            RuleFlowRenderer.paintLine(g2, fromRect, toRect);
        }
        for (RFNode node : this.nodes.values()) {
            if (node instanceof ForEach) continue;
            node.paint(g2);
        }
    }

    public static void paintLine(Graphics2D g2, Rectangle2D.Double from, Rectangle2D.Double to) {
        Point2D.Double fromRectCenter = new Point2D.Double(from.getCenterX(), from.getCenterY());
        Point2D.Double toRectCenter = new Point2D.Double(to.getCenterX(), to.getCenterY());
        Line2D.Double line = new Line2D.Double(fromRectCenter, toRectCenter);
        Point2D.Double p1 = new Point2D.Double();
        GraphicsUtil.getLineRectangleIntersection(from, line, p1);
        Point2D.Double p2 = new Point2D.Double();
        GraphicsUtil.getLineRectangleIntersection(to, line, p2);
        RuleFlowRenderer.drawArrow(g2, line, 1.0f, true);
    }

    public static void drawArrow(Graphics2D g2d, Line2D.Double line, float stroke, boolean arrow) {
        int xCenter = (int)line.getX1();
        int yCenter = (int)line.getY1();
        double x = line.getX2();
        double y = line.getY2();
        double aDir = Math.atan2((double)xCenter - x, (double)yCenter - y);
        int i1 = 12 + (int)(stroke * 2.0f);
        int i2 = 6 + (int)stroke;
        Line2D.Double base = new Line2D.Double(x + (double)RuleFlowRenderer.xCor(i1, aDir + 0.5), y + (double)RuleFlowRenderer.yCor(i1, aDir + 0.5), x + (double)RuleFlowRenderer.xCor(i1, aDir - 0.5), y + (double)RuleFlowRenderer.yCor(i1, aDir - 0.5));
        Point2D.Double intersect = new Point2D.Double();
        GraphicsUtil.getLineLineIntersection(line, base, intersect);
        g2d.setPaint(LINE_COLOR);
        if (arrow) {
            g2d.draw(new Line2D.Double(xCenter, yCenter, intersect.x, intersect.y));
            g2d.setStroke(new BasicStroke(1.0f));
            Polygon tmpPoly = new Polygon();
            tmpPoly.addPoint((int)x, (int)y);
            tmpPoly.addPoint((int)x + RuleFlowRenderer.xCor(i1, aDir + 0.5), (int)y + RuleFlowRenderer.yCor(i1, aDir + 0.5));
            tmpPoly.addPoint((int)x + RuleFlowRenderer.xCor(i1, aDir - 0.5), (int)y + RuleFlowRenderer.yCor(i1, aDir - 0.5));
            tmpPoly.addPoint((int)x, (int)y);
            g2d.drawPolygon(tmpPoly);
        } else {
            g2d.draw(new Line2D.Double(xCenter, yCenter, x, y));
        }
    }

    private static int yCor(int len, double dir) {
        return (int)((double)len * Math.cos(dir));
    }

    private static int xCor(int len, double dir) {
        return (int)((double)len * Math.sin(dir));
    }

    public String getNodeName(String id) {
        RFNode node = this.nodes.get(id);
        return node != null ? node.name : null;
    }

    public void write(OutputStream output) throws IOException {
        BufferedImage aimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = aimg.createGraphics();
        this.paint(g);
        g.dispose();
        ImageIO.write((RenderedImage)aimg, "png", output);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static void paintBall(Graphics2D g2, Color c) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int diameter = 16;
        Paint oldPaint = g2.getPaint();
        g2.setColor(c);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        Paint p = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.4f), 0.0f, diameter, new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), 0.0f, diameter, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new RadialGradientPaint(new Point2D.Double((double)diameter * 0.4, (double)diameter * 0.45), (float)diameter / 2.0f, new float[]{0.0f, 0.95f}, new Color[]{new Color(c.getRed(), c.getGreen(), c.getBlue(), 127), new Color(0.0f, 0.0f, 0.0f, 0.0f)});
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        p = new RadialGradientPaint(new Point2D.Double((double)diameter / 2.0, (double)diameter * 1.5), (float)diameter / 2.3f, new Point2D.Double((double)diameter / 2.0, (double)diameter * 1.75 + 6.0), new float[]{0.0f, 0.8f}, new Color[]{new Color(c.getRed(), c.getGreen(), c.getBlue(), 255), new Color(c.getRed(), c.getGreen(), c.getBlue(), 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, AffineTransform.getScaleInstance(1.0, 0.5));
        g2.setPaint(p);
        g2.fillOval(0, 0, diameter - 1, diameter - 1);
        g2.setPaint(oldPaint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NodeState {
        IN_PROGRESS,
        COMPLETED,
        INACTIVE,
        FAILED;

    }

    private static class RFConnection {
        private final RFNode from;
        private final RFNode to;

        public RFConnection(RFNode from, RFNode to) {
            this.from = from;
            this.to = to;
        }
    }

    public class ForEach
    extends RFNode {
        public ForEach(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public void paint(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle2D.Double rect = this.asRectangle();
            Shape shape = this.getShape();
            g2.setPaint(this.getColor());
            g2.fill(shape);
            Shape clip = g2.getClip();
            Color stateColor = this.getStateColor();
            if (stateColor != null) {
                g2.setPaint(stateColor);
                g2.setClip((int)rect.x, (int)rect.y, 25, (int)rect.height);
                g2.fill(shape);
            }
            g2.setClip(clip);
            g2.setPaint(LINE_COLOR);
            g2.draw(shape);
            g2.setColor(TEXT_COLOR);
            g2.setFont(FONT);
            g2.drawString(this.name, (int)(rect.x + 6.0), (int)(rect.y + 18.0));
        }
    }

    public class End
    extends RFNode {
        public End(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public Image getImage() {
            return endImage;
        }
    }

    public class Start
    extends RFNode {
        public Start(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public Image getImage() {
            return startImage;
        }
    }

    public class Event
    extends RFNode {
        public Event(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public Image getImage() {
            return eventImage;
        }
    }

    public class Split
    extends RFNode {
        private Color color;

        public Split(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
            this.color = new Color(70, 130, 180);
        }

        public Shape getShape() {
            return new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        }

        public Color getColor() {
            return this.color;
        }

        public Image getImage() {
            return joinImage;
        }
    }

    public class Script
    extends WorkItem {
        public Script(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public Image getImage() {
            return humanTaskImage;
        }
    }

    public class Build
    extends WorkItem {
        public String project;
        private Run run;

        public Build(String type, String name, String id, String project, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
            this.project = project;
        }

        public Image getImage() {
            return workItemImage;
        }

        public boolean paintIcon(Graphics2D g2, int x, int y) {
            if (this.run == null || this.run.getResult() == null) {
                return super.paintIcon(g2, x, y);
            }
            Color c = this.run.getResult() == Result.SUCCESS ? BUILD_SUCCESS_COLOR : (this.run.getResult() == Result.UNSTABLE ? BUILD_UNSTABLE_COLOR : (this.run.getResult() == Result.ABORTED ? BUILD_CANCELED_COLOR : BUILD_FAILED_COLOR));
            g2.translate(x, y);
            RuleFlowRenderer.paintBall(g2, c);
            g2.translate(-x, -y);
            return true;
        }

        public String getUrl() {
            if (this.run != null) {
                return this.run.getUrl();
            }
            Job job = RuleFlowRenderer.this.getJobUrl(this.project);
            if (job != null) {
                return job.getUrl();
            }
            return null;
        }
    }

    public class HumanTask
    extends WorkItem {
        public HumanTask(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
        }

        public Image getImage() {
            return humanTaskImage;
        }
    }

    public class WorkItem
    extends RFNode {
        private Color color;

        public WorkItem(String type, String name, String id, int x, int y, int width, int height) {
            super(type, name, id, x, y, width, height);
            this.color = new Color(255, 250, 205);
        }

        public Shape getShape() {
            return new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, 25.0, 25.0);
        }

        public Color getColor() {
            return this.color;
        }

        public Image getImage() {
            return workItemImage;
        }
    }

    public class RFNode {
        public final String type;
        public final String name;
        public final String id;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public NodeState state = NodeState.INACTIVE;
        private String url;

        public RFNode(String type, String name, String id, int x, int y, int width, int height) {
            this.type = type;
            this.name = name;
            this.id = id;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public Rectangle2D.Double asRectangle() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public Shape getShape() {
            return this.asRectangle();
        }

        public Image getImage() {
            return null;
        }

        public Color getColor() {
            return Color.WHITE;
        }

        public Color getStateColor() {
            switch (this.state) {
                case IN_PROGRESS: {
                    return NODE_IN_PROGRESS_COLOR;
                }
                case INACTIVE: {
                    return null;
                }
                case COMPLETED: {
                    return NODE_COMPLETE_COLOR;
                }
            }
            return null;
        }

        public void paint(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle2D.Double rect = this.asRectangle();
            Shape shape = this.getShape();
            g2.setPaint(this.getColor());
            g2.fill(shape);
            Shape clip = g2.getClip();
            Color stateColor = this.getStateColor();
            if (stateColor != null) {
                g2.setPaint(stateColor);
                g2.setClip((int)rect.x, (int)rect.y, 25, (int)rect.height);
                g2.fill(shape);
            }
            g2.setClip(clip);
            g2.setPaint(LINE_COLOR);
            g2.draw(shape);
            int imageY = (int)(rect.y + rect.height / 2.0 - 8.0);
            int imageX = (int)rect.x + 6;
            boolean painted = this.paintIcon(g2, imageX, imageY);
            int textWidth = g2.getFontMetrics().stringWidth(this.name);
            int textHeight = g2.getFontMetrics().getAscent();
            g2.setColor(TEXT_COLOR);
            g2.setFont(FONT);
            g2.drawString(this.name, (int)(rect.x + (double)(painted ? 10 : 0) + (rect.width - (double)textWidth) / 2.0), (int)(rect.y + (rect.height + (double)textHeight) / 2.0));
        }

        public boolean paintIcon(Graphics2D g2, int imageX, int imageY) {
            Image image = this.getImage();
            if (image != null) {
                g2.drawImage(image, imageX, imageY, null);
            }
            return image != null;
        }
    }
}

