/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunWrapper
implements Externalizable {
    private transient Run<?, ?> run;

    public RunWrapper(Run<?, ?> run) {
        this.run = run;
    }

    public RunWrapper() {
    }

    public Run getRun() {
        return this.run;
    }

    public String getDisplayName() {
        return this.run.getFullDisplayName();
    }

    public Result getResult() {
        return this.run.getResult();
    }

    public boolean isSuccess() {
        return this.run.getResult() == Result.SUCCESS;
    }

    public boolean isUnstable() {
        return this.run.getResult() == Result.UNSTABLE;
    }

    public String getProjectName() {
        return this.run.getParent().getName();
    }

    public String toString() {
        return this.run.getFullDisplayName();
    }

    private String getParameter(ParametersAction parameters, String name) {
        for (ParameterValue value : parameters.getParameters()) {
            if (!name.equals(value.getName())) continue;
            return ((StringParameterValue)value).value;
        }
        return null;
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunWrapper other = (RunWrapper)obj;
        return this.run == other.run;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(RunWrapper.runToString(this.run));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.run = RunWrapper.stringToRun(in.readUTF());
    }

    private static String runToString(Run run) {
        if (run == null) {
            return "";
        }
        Job job = run.getParent();
        String convertedValue = job.getName() + "#" + run.getNumber();
        return convertedValue;
    }

    private static Run stringToRun(String id) {
        if ("".equals(id)) {
            return null;
        }
        int hash = id.lastIndexOf(35);
        String jobName = id.substring(0, hash);
        String runNumber = id.substring(hash + 1);
        Hudson hudson = Hudson.getInstance();
        if (hudson == null) {
            return null;
        }
        Job job = (Job)hudson.getItem(jobName);
        if (job == null) {
            return null;
        }
        Run run = job.getBuildByNumber(Integer.parseInt(runNumber));
        return run;
    }
}

