/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.DroolsManagement;
import hudson.drools.DroolsRun;
import hudson.drools.PluginImpl;
import hudson.drools.Script;
import hudson.model.Job;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExecution {
    private String scriptName;
    private Map<String, Object> parameters;
    private Result result = Result.NOT_RUN;
    private final long workItemId;
    private final DroolsRun run;

    public ScriptExecution(DroolsRun run, String scriptName, long workItemId, Map<String, Object> parameters) {
        this.run = run;
        this.scriptName = scriptName;
        this.workItemId = workItemId;
        this.parameters = parameters;
        run.addScriptExecution(this);
        try {
            run.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.scriptName;
    }

    public void setId(String id) {
        this.scriptName = id;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void run() {
        final Script script = DroolsManagement.getInstance().getScript(this.scriptName);
        if (script == null) {
            throw new IllegalArgumentException("Unknown script " + this.scriptName);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ScriptExecution.this.result = Result.RUNNING;
                try {
                    Map scriptResults = script.execute(ScriptExecution.this.run.getLogWriter(), ScriptExecution.this.parameters);
                    ScriptExecution.this.result = Result.COMPLETED;
                    PluginImpl.getInstance().completeWorkItem(ScriptExecution.this.workItemId, scriptResults);
                }
                catch (Exception e) {
                    ScriptExecution.this.result = Result.FAILED;
                    e.printStackTrace();
                }
                finally {
                    try {
                        ScriptExecution.this.run.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public void doRun(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.run.checkPermission(Job.BUILD);
        this.run();
        rsp.forwardToPreviousPage(req);
    }

    public String getUrl() {
        return this.run.getUrl() + "scriptExecution/" + this.workItemId;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean hasFailed() {
        return this.result == Result.FAILED;
    }

    public DroolsRun getRun() {
        return this.run;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_RUN("Not Run"),
        RUNNING("Running"),
        FAILED("Failed"),
        COMPLETED("Completed");

        private String displayName;

        private Result(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

