/*
 * Decompiled with CFR 0.152.
 */
package hudson.drools;

import hudson.drools.DroolsRun;
import hudson.drools.NodeInstanceLog;
import org.drools.WorkingMemory;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;

public class WorkingMemoryHudsonLogger
extends WorkingMemoryLogger {
    public WorkingMemoryHudsonLogger(WorkingMemory workingMemory) {
        super((WorkingMemoryEventManager)workingMemory);
    }

    public WorkingMemoryHudsonLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    public void logEventCreated(LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 8: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.addProcessLog(processEvent.getProcessInstanceId(), processEvent.getProcessId());
                break;
            }
            case 10: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.processCompleted(processEvent.getProcessInstanceId());
                break;
            }
            case 24: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeEnterLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId());
                break;
            }
            case 26: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeExitLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId());
                break;
            }
        }
        if (logEvent instanceof RuleFlowLogEvent) {
            long processInstanceId = ((RuleFlowLogEvent)logEvent).getProcessInstanceId();
            DroolsRun.getFromProcessInstance(processInstanceId).getLogWriter().println(logEvent);
        }
    }

    private void addProcessLog(long processInstanceId, String processId) {
    }

    private void processCompleted(long processInstanceId) {
        DroolsRun run = DroolsRun.getFromProcessInstance(processInstanceId);
        if (run != null) {
            run.markCompleted();
        }
    }

    private void addNodeEnterLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId) {
        DroolsRun run = DroolsRun.getFromProcessInstance(processInstanceId);
        run.addLog(new NodeInstanceLog(0, processInstanceId, processId, nodeInstanceId, nodeId));
    }

    private void addNodeExitLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId) {
        DroolsRun run = DroolsRun.getFromProcessInstance(processInstanceId);
        run.addLog(new NodeInstanceLog(1, processInstanceId, processId, nodeInstanceId, nodeId));
    }

    public void dispose() {
    }
}

