/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import hudson.plugins.dry.util.Messages;
import hudson.plugins.dry.util.SingleFieldValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingValidator
extends SingleFieldValidator {
    private static final Set<String> ALL_CHARSETS = Collections.unmodifiableSet(new HashSet<String>(Charset.availableCharsets().keySet()));

    public EncodingValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response);
    }

    public static Set<String> getAvailableCharsets() {
        return ALL_CHARSETS;
    }

    public static Charset defaultCharset(String defaultEncoding) {
        try {
            if (StringUtils.isNotBlank((String)defaultEncoding)) {
                return Charset.forName(defaultEncoding);
            }
        }
        catch (UnsupportedCharsetException exception) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    public static LineIterator readFile(String fileName, String encoding) throws FileNotFoundException, IOException {
        FileInputStream stream = new FileInputStream(new File(fileName));
        if (StringUtils.isNotBlank((String)encoding)) {
            return IOUtils.lineIterator((InputStream)stream, (String)encoding);
        }
        return IOUtils.lineIterator((InputStream)stream, null);
    }

    public void check(String encoding) throws IOException, ServletException {
        try {
            if (StringUtils.isEmpty((String)encoding) || Charset.forName(encoding) != null) {
                this.ok();
            }
        }
        catch (IllegalCharsetNameException exception) {
            this.error(Messages.FieldValidator_Error_DefaultEncoding());
        }
        catch (UnsupportedCharsetException exception) {
            this.error(Messages.FieldValidator_Error_DefaultEncoding());
        }
    }
}

