/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import hudson.plugins.dry.util.HealthDescriptor;
import hudson.plugins.dry.util.ThresholdValidator;
import hudson.plugins.dry.util.model.AnnotationProvider;
import hudson.plugins.dry.util.model.Priority;
import org.jvnet.localizer.Localizable;

public abstract class AbstractHealthDescriptor
implements HealthDescriptor {
    private static final long serialVersionUID = -3709673381162699834L;
    private final Priority priority;
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String healthy;
    private final String unHealthy;
    @Deprecated
    private transient boolean isFailureThresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean isHealthyReportEnabled;

    public AbstractHealthDescriptor(HealthDescriptor healthDescriptor) {
        this.priority = healthDescriptor.getMinimumPriority();
        this.threshold = healthDescriptor.getThreshold();
        this.newThreshold = healthDescriptor.getNewThreshold();
        this.failureThreshold = healthDescriptor.getFailureThreshold();
        this.newFailureThreshold = healthDescriptor.getNewFailureThreshold();
        this.healthy = healthDescriptor.getHealthy();
        this.unHealthy = healthDescriptor.getUnHealthy();
    }

    public AbstractHealthDescriptor() {
        this.threshold = "";
        this.newThreshold = "";
        this.failureThreshold = "";
        this.newFailureThreshold = "";
        this.healthy = "";
        this.unHealthy = "";
        this.priority = Priority.LOW;
    }

    public Priority getMinimumPriority() {
        return this.priority;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public boolean isEnabled() {
        return this.isHealthyReportEnabled() || this.isThresholdEnabled();
    }

    protected abstract Localizable createDescription(AnnotationProvider var1);

    public boolean isThresholdEnabled() {
        return ThresholdValidator.isValid(this.threshold);
    }

    public int getMinimumAnnotations() {
        if (this.isThresholdEnabled()) {
            return ThresholdValidator.convert(this.threshold);
        }
        throw new IllegalArgumentException("Threshold is not valid: " + this.threshold);
    }

    public boolean isHealthyReportEnabled() {
        if (ThresholdValidator.isValid(this.healthy) && ThresholdValidator.isValid(this.unHealthy)) {
            int healthyNumber = ThresholdValidator.convert(this.healthy);
            int unHealthyNumber = ThresholdValidator.convert(this.unHealthy);
            return unHealthyNumber > healthyNumber;
        }
        return false;
    }

    public int getHealthyAnnotations() {
        if (this.isHealthyReportEnabled()) {
            return ThresholdValidator.convert(this.healthy);
        }
        throw new IllegalArgumentException("Healthy values are not valid: " + this.healthy + ", " + this.unHealthy);
    }

    public int getUnHealthyAnnotations() {
        if (this.isHealthyReportEnabled()) {
            return ThresholdValidator.convert(this.unHealthy);
        }
        throw new IllegalArgumentException("Healthy values are not valid: " + this.healthy + ", " + this.unHealthy);
    }
}

